/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PrimitiveUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;

    private PrimitiveUtils() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey(clazz);
    }

    public static <T> Class<T> wrap(Class<T> type) {
        return PRIMITIVE_TO_WRAPPER_TYPE.getOrDefault(type, type);
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.getOrDefault(type, type);
    }

    static {
        HashMap primToWrap = new HashMap(16);
        HashMap wrapToPrim = new HashMap(16);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        PrimitiveUtils.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(wrapToPrim);
    }
}

