/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.qubership.atp.ei.ntt.settings.CermFileSystem;

public final class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);

    private static void trace(@Nonnull String message) {
        if (log.isTraceEnabled()) {
            log.trace((Object)message);
        }
    }

    @Nonnull
    public static String readTextFile(@Nonnull File file) {
        String path = file.getAbsolutePath();
        try {
            return IOUtils.toString((InputStream)new FileInputStream(path), (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException ex) {
            log.error((Object)String.format("Cannot find file [%s]", path), (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)String.format("Cannot read file [%s]", path), (Throwable)ex);
        }
        return "";
    }

    public static void writeTextFile(@Nonnull String text, @Nonnull String fileName) {
        File file = new File(fileName);
        try {
            file.createNewFile();
            PrintWriter out = new PrintWriter(file.getAbsoluteFile(), Charsets.UTF_8.name());
            out.print(text);
            out.close();
        }
        catch (IOException e) {
            log.error((Object)String.format("Cannot write text file [%s]", fileName), (Throwable)e);
        }
    }

    @Nonnull
    public static String getPathToFile(@Nonnull File file) {
        try {
            String canonicalPath = file.getCanonicalPath();
            return canonicalPath.replace(File.separator, "/");
        }
        catch (IOException e) {
            log.error((Object)String.format("Can not get canonical path for the [%s]", file.getPath()), (Throwable)e);
            return file.getAbsolutePath();
        }
    }

    public static String getRelatedPathToFile(@Nonnull File file) {
        return FileUtils.getRelatedPathToFile(CermFileSystem.APP_DIR, file);
    }

    @Nonnull
    public static String getRelatedPathToFile(@Nonnull File appDir, @Nonnull File file) {
        try {
            String filePath = file.getCanonicalPath();
            String appDirPath = appDir.getCanonicalPath();
            boolean isSubPath = (filePath + File.separator).contains(appDirPath + File.separator);
            return isSubPath ? filePath.replace(appDirPath, ".").replace(File.separator, "/") : filePath;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can not do [%s] path to relate to [%s]", file, appDir), e);
        }
    }

    public static void deleteFileOrDirectoryWithSpecificName(String rootDirectory, String containsLine) {
        File directory = new File(rootDirectory);
        Object[] files = directory.list((dir, name) -> name.contains(containsLine));
        if (files != null) {
            log.info((Object)("Start deleting files " + Arrays.toString(files)));
            for (Object file : files) {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)new File(Paths.get(rootDirectory, new String[]{file}).toUri()));
                }
                catch (IOException e) {
                    log.error((Object)("Failed delete file: " + (String)file));
                }
            }
        } else {
            log.error((Object)("File with name contains \"" + containsLine + "\" not found."));
        }
    }

    public static boolean isPathRelated(@Nonnull String filePath) {
        try {
            File file = new File(filePath);
            return !file.isAbsolute() && file.getCanonicalPath().startsWith(CermFileSystem.APP_DIR.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can not check if [%s] path relates to application directory", filePath), e);
        }
    }

    @Nonnull
    public static String getAbsolutePath(@Nonnull String relatedPath) {
        File concat = new File(CermFileSystem.APP_DIR, relatedPath);
        try {
            return concat.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can not get canonical path of [%s]", concat), e);
        }
    }

    @Nonnull
    public static String getParentFolder(@Nonnull File file) {
        try {
            return URLDecoder.decode(file.getParentFile().getCanonicalPath(), Charsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot get canonical path for [%s]", file), e);
        }
    }

    public static void createIfNotExists(@Nonnull File file) {
        if (file == null || file.exists()) {
            return;
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            log.error((Object)String.format("Cannot create new file [%s]", file.getName()), (Throwable)e);
        }
    }

    @Nonnull
    public static List<String> readLines(@Nonnull File file) {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        try {
            return org.apache.commons.io.FileUtils.readLines((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.error((Object)String.format("Cannot read lines from file [%s]", file.getAbsolutePath()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static void createFolders(@Nonnull File file) {
        if (file == null) {
            return;
        }
        File folder = new File(file.getParent());
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static void storeObject(@Nonnull Serializable obj, @Nonnull String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            FileUtils.createFolders(file);
        } else {
            file.delete();
        }
        FileUtils.trace(String.format("Try to write object [%s] to file [%s]", obj, file.getPath()));
        try (ObjectOutputStream oStream = new ObjectOutputStream(new FileOutputStream(file));){
            oStream.writeObject(obj);
            oStream.flush();
            FileUtils.trace(String.format("Object [%s] was successfully write to file [%s]", obj, file.getPath()));
        }
        catch (FileNotFoundException e) {
            log.error((Object)String.format("Cannot find file [%s]", file.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)String.format("Cannot store object in [%s]", file.getAbsolutePath()), (Throwable)e);
        }
    }

    @Nullable
    public static Serializable loadObject(@Nonnull String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            log.error((Object)String.format("The file [%s] wasn't found. Please check the name.", file.getPath()));
            return null;
        }
        FileUtils.trace(String.format("Try to read object from file [%s]", file.getPath()));
        Object obj = null;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            obj = ois.readObject();
            FileUtils.trace(String.format("Object [%s] was successfully read from file [%s]", obj, file.getPath()));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"ClassNotFoundException", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"IOException", (Throwable)e);
        }
        return (Serializable)obj;
    }

    @Nullable
    public static BufferedReader createReader(@Nonnull File file) {
        try {
            FileInputStream inStream = org.apache.commons.io.FileUtils.openInputStream((File)file);
            return new BufferedReader(new InputStreamReader((InputStream)inStream, Charsets.UTF_8));
        }
        catch (Exception e) {
            log.error((Object)String.format("Cannot create reader stream for [%s]", file.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    @Nonnull
    public static File createFileWithExtension(@Nonnull String absoluteFilePath, @Nonnull String extension) {
        String projectAbsolutePath = absoluteFilePath;
        if (!StringUtils.endsWithIgnoreCase((CharSequence)projectAbsolutePath, (CharSequence)extension)) {
            projectAbsolutePath = projectAbsolutePath.concat(extension);
        }
        File newFile = new File(projectAbsolutePath);
        FileUtils.createIfNotExists(newFile);
        return newFile;
    }
}

