/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ReflectionUtils {
    private static Logger log = Logger.getLogger(ReflectionUtils.class);

    public static <T> T getInstance(Class<T> clazz) {
        T result = null;
        try {
            result = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static <T> T getInstance(Class<T> clazz, String value) {
        T resource = null;
        try {
            resource = clazz.getConstructor(String.class).newInstance(value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return resource;
    }

    public static List<Field> getAllDeclaredFields(Class clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(ReflectionUtils.getAllDeclaredFields(clazz.getSuperclass()));
        result.addAll(Arrays.stream(clazz.getDeclaredFields()).collect(Collectors.toList()));
        return result;
    }
}

