/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.utils;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.ei.ntt.dto.Action;
import org.qubership.atp.ei.ntt.dto.ActionParameter;
import org.qubership.atp.ei.ntt.dto.ComplexActionParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesCompiler {
    private static final Logger log = LoggerFactory.getLogger(VariablesCompiler.class);
    private static final String STRING_PARAM_REGEXP = "\\$\\{([a-zA-Z0-9_.]*)\\}";
    private static final String ARRAY_REGEXP = "\\(([a-zA-Z0-9_${}'\"\\s,]*)\\)";
    private static final String MAP_REGEXP = "\\(([a-zA-Z0-9_${}='\"\\s,]*)\\)";
    private static final Pattern STRING_PARAM_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9_.]*)\\}");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\(([a-zA-Z0-9_${}'\"\\s,]*)\\)");
    private static final Pattern MAP_PATTERN = Pattern.compile("\\(([a-zA-Z0-9_${}='\"\\s,]*)\\)");
    private static final String FILE_NAME_REGEX = "\\/attachment\\/\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b(\\/)?";
    private static final String UUID_REGEX = "(\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b)";
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("\\/attachment\\/\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b(\\/)?");
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b)");
    private static final String PIPE = "\\|";
    private static final String OPEN_SQUARE_BRACKET = "\\[";
    private static final String CLOSE_SQUARE_BRACKET = "\\]";
    private static final String DOLLAR_SIGN = "$";
    private static final String SCREENED_DOLLAR_SIGN = "\\$";
    private static final String SCREENED_PIPE = "\\\\|";
    private static final String SCREENED_OPEN_SQUARE_BRACKET = "\\\\[";
    private static final String SCREENED_CLOSE_SQUARE_BRACKET = "\\\\]";
    private static final String DOUBLE_BACKSLASH = "\\\\\\\\";
    private static final String SCREENED_DOUBLE_BACKSLASH = "\\\\\\\\\\\\\\\\";

    public static boolean isFile(String name) {
        Matcher stringMatcher = FILE_NAME_PATTERN.matcher(name);
        return stringMatcher.matches();
    }

    public static String getFileId(String name) {
        Matcher stringMatcher = UUID_PATTERN.matcher(name);
        if (stringMatcher.find()) {
            return stringMatcher.group(1);
        }
        return name;
    }

    public Action precompileStringParameters(Action actionEntity) {
        String name = actionEntity.getName();
        Matcher arrayMatcher = ARRAY_PATTERN.matcher(name);
        Matcher mapMatcher = MAP_PATTERN.matcher(name);
        actionEntity.getParameters().forEach(param -> {
            if (param.getComplexParam() == null) {
                this.precompileParameterValue(actionEntity, (ActionParameter)param);
            } else {
                this.precompileComplexParameterValue(actionEntity, arrayMatcher, (ActionParameter)param);
                this.precompileComplexParameterValue(actionEntity, mapMatcher, (ActionParameter)param);
            }
        });
        return actionEntity;
    }

    private void precompileParameterValue(Action actionEntity, ActionParameter actionParameter) {
        String screenedActionParameter = actionParameter.getName().replaceAll(PIPE, SCREENED_PIPE).replaceAll(OPEN_SQUARE_BRACKET, SCREENED_OPEN_SQUARE_BRACKET).replaceAll(CLOSE_SQUARE_BRACKET, SCREENED_CLOSE_SQUARE_BRACKET).replaceAll(DOUBLE_BACKSLASH, SCREENED_DOUBLE_BACKSLASH).replace(DOLLAR_SIGN, SCREENED_DOLLAR_SIGN);
        String stringInQuotes = "[\\\"|\\'](" + screenedActionParameter + ")[|\\\"|\\']";
        String stringInSquareBrackets = "[\\[](" + screenedActionParameter + ")[\\]]";
        String stringInTriangularBrackets = "[\\<](" + screenedActionParameter + ")[\\>]";
        Pattern patternInQuotes = Pattern.compile(stringInQuotes);
        Pattern patternInSquareBrackets = Pattern.compile(stringInSquareBrackets);
        Pattern patternInTriangularBrackets = Pattern.compile(stringInTriangularBrackets);
        if (actionEntity != null) {
            this.replaceByMatcherForPattern(actionEntity, actionParameter, patternInQuotes);
            this.replaceByMatcherForPattern(actionEntity, actionParameter, patternInSquareBrackets);
            this.replaceByMatcherForPattern(actionEntity, actionParameter, patternInTriangularBrackets);
        }
    }

    private void replaceByMatcherForPattern(Action actionEntity, ActionParameter actionParameter, Pattern pattern) {
        Matcher matcher = pattern.matcher(actionEntity.getName());
        if (matcher.find()) {
            String value = (String)StringUtils.defaultIfEmpty((CharSequence)actionParameter.getValue(), (CharSequence)"");
            actionEntity.setName(actionEntity.getName().replace(matcher.group(0), matcher.group(0).replace(matcher.group(1), value)));
        }
    }

    private void precompileComplexParameterValue(Action actionEntity, Matcher matcher, ActionParameter actionParameter) {
        List<String> values;
        ComplexActionParameter complexParam;
        if (actionParameter.getComplexParam().getType().equals((Object)ComplexActionParameter.Type.ARRAY) && matcher.find()) {
            complexParam = actionParameter.getComplexParam();
            values = complexParam.getArrayParams().stream().map(complexActionParam -> {
                String value = complexActionParam.getValue();
                return "\"" + value + "\"";
            }).collect(Collectors.toList());
            this.joinComplexValue(actionEntity, matcher, values);
        }
        if (actionParameter.getComplexParam().getType().equals((Object)ComplexActionParameter.Type.MAP) && matcher.find()) {
            complexParam = actionParameter.getComplexParam();
            values = complexParam.getMapParams().stream().map(complexActionParam -> {
                String key = complexActionParam.getParamKey().getValue();
                String value = complexActionParam.getParamValue().getValue();
                return "\"" + key + "\"='" + value + "'";
            }).collect(Collectors.toList());
            this.joinComplexValue(actionEntity, matcher, values);
        }
    }

    private void joinComplexValue(Action actionEntity, Matcher matcher, List<String> values) {
        String joinedValues = String.join((CharSequence)",", values);
        String replacement = ("(" + joinedValues + ")").replaceAll(SCREENED_DOLLAR_SIGN, "\\\\\\$").replaceAll("\\\\n", "\\\\\\\\n");
        String regex = matcher.group(0).replaceAll("\\(", "\\\\\\(").replaceAll("\\)", "\\\\\\)");
        actionEntity.setName(actionEntity.getName().replaceFirst(regex, replacement));
    }

    public String precompileVariables(String expression, Map<String, Object> variables) {
        log.debug("precompileVariables (expression = {}, variables = {})", (Object)expression, variables);
        Matcher stringMatcher = STRING_PARAM_PATTERN.matcher(expression);
        while (stringMatcher.find()) {
            String group = stringMatcher.group(1);
            Object replacement = variables.get(group);
            expression = replacement == null ? expression : expression.replace(stringMatcher.group(0), String.valueOf(replacement));
        }
        log.debug("result expression {}", (Object)expression);
        return expression;
    }
}

