/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.cassandra;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.cassandra.TraceReactiveSession;
import org.springframework.data.cassandra.ReactiveSession;

public class TraceReactiveSessionBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    public TraceReactiveSessionBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof ReactiveSession) {
            return this.create((ReactiveSession)bean);
        }
        return bean;
    }

    private ReactiveSession create(ReactiveSession session) {
        return TraceReactiveSession.create((ReactiveSession)session, (BeanFactory)this.beanFactory);
    }
}

