/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ei.node.CancellableExportImportTask;
import org.qubership.atp.ei.node.ExportExecutor;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ExportNodeInfo;
import org.qubership.atp.ei.node.dto.ExportScope;
import org.qubership.atp.ei.node.dto.RunNodeRequest;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ExportImportFilesService;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.MetricsExportImportService;
import org.qubership.atp.ei.node.services.impl.NotifyService;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ExportExecutorWrapper
implements CancellableExportImportTask,
ExportExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExportExecutorWrapper.class);
    private final ExportExecutor exportExecutor;
    private final ExportNodeInfo exportNodeInfo;
    private final NotifyService notifyService;
    private final ObjectMapper objectMapper;
    private final UUID projectId;
    private final ExportFormat format;
    private final Path workDir;
    private final RunNodeRequest request;
    private final ExportScope exportScope;
    private final ExportImportFilesService exportImportFilesService;
    private final SecurityContext securityContext;
    private final FileService fileService;
    private boolean isCancelled;
    private Map<String, String> mdcContext;
    private final MetricsExportImportService metricsExportImportService;

    public ExportExecutorWrapper(RunNodeRequest request, Path defaultWorkDir, ExportExecutor exportExecutor, ExportNodeInfo exportNodeInfo, NotifyService notifyService, ObjectMapper objectMapper, ExportImportFilesService exportImportFilesService, FileService fileService, MetricsExportImportService metricsExportImportService) {
        this.request = request;
        this.projectId = request.getProjectId();
        this.exportScope = request.getExportScope();
        this.exportExecutor = exportExecutor;
        this.notifyService = notifyService;
        this.exportNodeInfo = exportNodeInfo;
        this.objectMapper = objectMapper;
        this.format = request.getExportFormat();
        this.exportImportFilesService = exportImportFilesService;
        this.securityContext = SecurityContextHolder.getContext();
        this.fileService = fileService;
        this.workDir = this.createExportWorkDir(defaultWorkDir, fileService);
        this.mdcContext = MDC.getCopyOfContextMap();
        this.metricsExportImportService = metricsExportImportService;
    }

    private Path createExportWorkDir(Path defaultWorkDir, FileService fileService) {
        if (Files.exists(defaultWorkDir, new LinkOption[0])) {
            fileService.deletePath(defaultWorkDir);
        }
        return fileService.createDirectory(defaultWorkDir);
    }

    @Override
    public Object call() throws Exception {
        String fileId;
        Path dir;
        log.debug("Export wrapper, mdcContext = {}", this.mdcContext);
        Stopwatch timer = Stopwatch.createStarted();
        this.metricsExportImportService.registerProcess(this.request.getProjectId().toString(), this.request.getProcessId(), "active.export.process.count");
        MdcUtils.setContextMap(this.mdcContext);
        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
        try {
            this.exportToFolder(new ExportImportData(this.projectId, this.exportScope, this.format), this.workDir);
            dir = this.fileService.packDirectory(this.workDir);
            fileId = this.exportImportFilesService.storeInGridFs(dir, this.request.getProcessId());
        }
        catch (Exception e) {
            log.error("Error occurred while exporting", (Throwable)e);
            if (!this.isCancelled()) {
                this.notifyService.notifyExportFlow(e, this.request);
            }
            throw e;
        }
        finally {
            this.fileService.deletePath(this.workDir);
            try {
                this.metricsExportImportService.addTimeMetric(this.request.getProjectId(), timer, "total.time.export.processes");
                this.metricsExportImportService.unregisterProcess(UUID.fromString(this.request.getProcessId()));
            }
            catch (Throwable e) {
                log.error("Unable unregister metric for processId {}", (Object)this.request.getProcessId(), (Object)e);
                throw new ExportException("Unable unregister metric for processId " + this.request.getProcessId());
            }
        }
        this.notifyService.notifyExportFlow(this.request, fileId);
        return dir;
    }

    private void putExportNodeInfoInDir(Path workDir) {
        Path exportNodeInfoFile = workDir.resolve(this.getExportImplementationName() + ".json");
        this.objectMapper.writeValue(exportNodeInfoFile.toFile(), (Object)this.exportNodeInfo);
    }

    @Override
    public void exportToFolder(ExportImportData exportData, Path workDir) throws Exception {
        log.info("Export project {} with objects {} started. format {} ", new Object[]{this.projectId, this.exportScope, this.format});
        Path dirForExport = workDir;
        if (ExportFormat.ATP == this.format) {
            dirForExport = this.fileService.createDirectory(this.getExportImplementationName(), workDir);
            this.putExportNodeInfoInDir(workDir);
        }
        this.exportExecutor.exportToFolder(exportData, dirForExport);
        if (ExportFormat.ATP == this.format) {
            if (this.fileService.isDirNotEmpty(dirForExport)) {
                this.fileService.packDirectory(dirForExport);
            }
            this.fileService.deletePath(dirForExport);
        }
        log.info("Export project {} with objects {} finished", (Object)this.projectId, (Object)this.exportScope);
    }

    @Override
    public String getExportImplementationName() {
        return this.exportExecutor.getExportImplementationName();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void setCancelled() {
        this.isCancelled = true;
    }

    public ExportExecutor getExportExecutor() {
        return this.exportExecutor;
    }

    public ExportNodeInfo getExportNodeInfo() {
        return this.exportNodeInfo;
    }

    public NotifyService getNotifyService() {
        return this.notifyService;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public ExportFormat getFormat() {
        return this.format;
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public RunNodeRequest getRequest() {
        return this.request;
    }

    public ExportScope getExportScope() {
        return this.exportScope;
    }

    public ExportImportFilesService getExportImportFilesService() {
        return this.exportImportFilesService;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public Map<String, String> getMdcContext() {
        return this.mdcContext;
    }

    public MetricsExportImportService getMetricsExportImportService() {
        return this.metricsExportImportService;
    }
}

