/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.model.impl;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class Context {
    private Predicate<JsonStreamContext> unfoldPredicate = ctx -> false;
    private boolean isFullSerialization;
    private boolean isFullDbFetching;

    public Context(boolean isFullSerialization) {
        this.isFullSerialization = isFullSerialization;
        this.isFullDbFetching = isFullSerialization;
    }

    public Context() {
    }

    public boolean isFullSerialization() {
        return this.isFullSerialization;
    }

    public void setFullSerialization(boolean fullSerialization) {
        this.isFullSerialization = fullSerialization;
    }

    public void setFullDbFetching(boolean fullDbFetching) {
        this.isFullDbFetching = fullDbFetching;
    }

    public boolean isFullDbFetching() {
        return this.isFullDbFetching;
    }

    public Predicate<JsonStreamContext> getUnfoldPredicate() {
        return this.unfoldPredicate;
    }

    public void setFieldsToUnfold(String ... fieldsToUnwrap) {
        this.unfoldPredicate = new UnfoldPredicate(fieldsToUnwrap);
    }

    private static class UnfoldPredicate
    implements Predicate<JsonStreamContext> {
        private final Set<String> fieldsToUnwrap;

        private UnfoldPredicate(String ... fieldsToUnwrap) {
            this(new HashSet<String>(Arrays.asList(fieldsToUnwrap)));
        }

        private UnfoldPredicate(Set<String> fieldsToUnwrap) {
            this.fieldsToUnwrap = fieldsToUnwrap;
        }

        private static Iterator<JsonStreamContext> pathToParent(final JsonStreamContext context) {
            return Iterators.filter((Iterator)new AbstractIterator<JsonStreamContext>(){
                private JsonStreamContext current;
                {
                    this.current = context;
                }

                protected JsonStreamContext computeNext() {
                    if (this.current == null) {
                        return (JsonStreamContext)this.endOfData();
                    }
                    JsonStreamContext toReturn = this.current;
                    this.current = this.current.getParent();
                    return toReturn;
                }
            }, mayBeArray -> !"Array".equals(mayBeArray.typeDesc()));
        }

        @Override
        public boolean test(JsonStreamContext context) {
            Iterator<JsonStreamContext> path = UnfoldPredicate.pathToParent(context);
            if (!path.hasNext()) {
                return false;
            }
            JsonStreamContext leaf = path.next();
            if (!path.hasNext()) {
                return false;
            }
            path.next();
            if (path.hasNext()) {
                return false;
            }
            return this.fieldsToUnwrap.contains(leaf.getCurrentName());
        }
    }
}

