/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.model.utils;

import com.google.common.base.Joiner;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.Identified;

public class Utils {
    public static final Joiner JOINER_DOT = Joiner.on((char)'.');
    private static final Supplier<?> EMPTY_SUP = new Supplier<Object>(){

        public String toString() {
            return "null supplier";
        }

        @Override
        public Object get() {
            return null;
        }
    };

    @Nonnull
    public static <T> Supplier<T> emptySup() {
        return EMPTY_SUP;
    }

    public static boolean isEqual(@Nonnull Identified o1, @Nullable Object o2) {
        return Utils.isEqual(Identified.class, o1, o2);
    }

    public static <T extends Identified> boolean isEqual(@Nonnull Class<T> clazz, @Nonnull T o1, @Nullable Object o2) {
        return o1 == o2 || Utils.isEqual(clazz, o1.getId(), o2);
    }

    public static <T extends Identified> boolean isEqual(@Nonnull Class<T> clazz, @Nonnull UUID id, @Nullable Object target) {
        if (target == null) {
            return false;
        }
        if (!clazz.isAssignableFrom(target.getClass())) {
            return false;
        }
        return Objects.equals(id, ((Identified)clazz.cast(target)).getId());
    }
}

