/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.component;

import org.qubership.atp.integration.configuration.feign.PublicGatewayFeignClient;
import org.qubership.atp.integration.configuration.model.AtpRoute;
import org.qubership.atp.integration.configuration.service.RouteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RouteRegisterComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteRegisterComponent.class);
    private final RouteService routeService;
    @Value(value="${atp.public.gateway.url:#{'http://atp-public-gateway:8080'}}")
    private String publicGatewayUrl;
    @Value(value="${atp.internal.gateway.url:#{'http://atp-internal-gateway:8080'}}")
    private String internalGatewayUrl;
    @Autowired
    private PublicGatewayFeignClient publicGatewayFeignClient;

    public RouteRegisterComponent(RouteService routeService) {
        this.routeService = routeService;
    }

    @Scheduled(initialDelayString="60000", fixedRateString="60000")
    public void routeRegister() {
        this.register();
    }

    @EventListener
    public void routeRegister(ApplicationReadyEvent event) {
        this.register();
    }

    private void register() {
        AtpRoute atpRoute = this.routeService.getRoute();
        if (atpRoute.isPublic()) {
            try {
                this.publicGatewayFeignClient.register(atpRoute);
            }
            catch (Exception e) {
                LOGGER.error("Cannot register route in public gateway '{}' using feign client: {}", (Object)this.publicGatewayUrl, (Object)e.getMessage());
            }
        }
        if (atpRoute.isInternal()) {
            this.register(this.internalGatewayUrl + "/register", atpRoute);
        }
    }

    private void register(String gatewayUrl, AtpRoute atpRoute) {
        RestTemplate template = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)atpRoute, (MultiValueMap)headers);
        try {
            template.postForEntity(gatewayUrl, (Object)entity, AtpRoute.class, new Object[0]);
            LOGGER.info("Route {} for {} was registered in {}", new Object[]{atpRoute.getPath(), atpRoute.getServiceId(), gatewayUrl});
        }
        catch (Exception e) {
            LOGGER.error("Cannot register route in {}", (Object)gatewayUrl, (Object)e);
        }
    }
}

