/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.interceptors;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.helpers.StompHelper;
import org.qubership.atp.integration.configuration.mdc.MdcField;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.CollectionUtils;

public class MdcChannelInterceptor
implements ChannelInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MdcChannelInterceptor.class);
    private final StompHelper bearerTokenStompHelper;
    private final JwtParseHelper jwtParseHelper;
    private final List<String> businessIds;

    public MdcChannelInterceptor(StompHelper bearerTokenStompHelper, JwtParseHelper parseHelper, String businessIdsString) {
        this.bearerTokenStompHelper = bearerTokenStompHelper;
        this.jwtParseHelper = parseHelper;
        this.businessIds = MdcUtils.convertIdNamesToList(businessIdsString);
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        block6: {
            try {
                MDC.clear();
                StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
                if (accessor == null) break block6;
                String token = this.bearerTokenStompHelper.extractBearerToken(accessor);
                if (token != null && StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)"Bearer ")) {
                    try {
                        if (!this.jwtParseHelper.isM2Mtoken(token)) {
                            MdcUtils.put(MdcField.USER_ID.toString(), this.jwtParseHelper.getUserIdFromToken(token));
                        }
                    }
                    catch (Exception e) {
                        log.error("Error while getting userId from token", (Throwable)e);
                    }
                }
                this.processHeaders(accessor);
            }
            catch (Exception e) {
                log.error("Error occurred while web socket message pre-processing", (Throwable)e);
            }
        }
        return message;
    }

    private void processHeaders(StompHeaderAccessor accessor) {
        if (!CollectionUtils.isEmpty(this.businessIds)) {
            this.businessIds.forEach(idName -> {
                String header = accessor.getFirstNativeHeader(MdcUtils.convertIdNameToHeader(idName));
                if (header != null) {
                    MdcUtils.put(idName.trim(), header);
                }
            });
        }
    }
}

