/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.adapter.filter;

import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.qubership.atp.common.logging.adapter.AtpHttpRequest;
import org.qubership.atp.common.logging.filter.CommonHttpRequestWrapper;
import org.qubership.atp.common.logging.utils.Util;
import org.springframework.http.HttpHeaders;

public class ContentCachingHttpRequest
implements AtpHttpRequest {
    private static final String QUESTION_MARK = "?";
    private static final String AMPERSAND = "&";
    private static final String EQUALS = "=";
    private final CommonHttpRequestWrapper request;

    @Override
    public HttpHeaders getHeaders() {
        return Util.getHeaders((HttpServletRequest)this.request);
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getUri() {
        StringBuilder uri = this.getParameters();
        uri.insert(0, this.request.getRequestURI());
        return uri.toString();
    }

    @Override
    public byte[] getBody() {
        return this.request.getContent();
    }

    private StringBuilder getParameters() {
        StringBuilder uri = new StringBuilder();
        Map parameters = this.request.getParameterMap();
        if (!parameters.isEmpty()) {
            parameters.forEach((key, val) -> Arrays.stream(val).forEach(value -> uri.append(AMPERSAND).append((String)key).append(EQUALS).append((String)value)));
            uri.replace(0, 1, QUESTION_MARK);
        }
        return uri;
    }

    public ContentCachingHttpRequest(CommonHttpRequestWrapper request) {
        this.request = request;
    }
}

