/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class CommonHttpRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(CommonHttpRequestWrapper.class);
    private final byte[] actualRequestBody;

    public CommonHttpRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.actualRequestBody = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public byte[] getContent() {
        return this.actualRequestBody;
    }

    public ServletInputStream getInputStream() {
        return new CachedServletInputStream(this.actualRequestBody);
    }

    public BufferedReader getReader() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.actualRequestBody);
        return new BufferedReader(new InputStreamReader(byteArrayInputStream));
    }

    private class CachedServletInputStream
    extends ServletInputStream {
        private InputStream cachedInputStream;

        public CachedServletInputStream(byte[] cachedBody) {
            this.cachedInputStream = new ByteArrayInputStream(cachedBody);
        }

        public boolean isFinished() {
            try {
                return this.cachedInputStream.available() == 0;
            }
            catch (IOException ex) {
                log.error(ex.getMessage());
                return false;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            return this.cachedInputStream.read();
        }
    }
}

