/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core;

import java.io.Closeable;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.key.KeyGenerator;
import org.polyjdbc.core.key.KeyGeneratorFactory;
import org.polyjdbc.core.query.QueryFactory;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.QueryRunnerFactory;
import org.polyjdbc.core.query.SimpleQueryRunner;
import org.polyjdbc.core.query.TransactionRunner;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.SchemaManagerFactory;
import org.polyjdbc.core.transaction.TransactionManager;
import org.polyjdbc.core.type.ColumnTypeMapper;
import org.polyjdbc.core.util.TheCloser;

public class DefaultPolyJDBC
implements PolyJDBC {
    private final Dialect dialect;
    private final QueryFactory queryFactory;
    private final KeyGenerator keyGenerator;
    private final QueryRunnerFactory queryRunnerFactory;
    private final SimpleQueryRunner simpleQueryRunner;
    private final TransactionRunner transactionRunner;
    private final SchemaManagerFactory schemaManagerFactory;
    private final String schemaName;

    DefaultPolyJDBC(Dialect dialect, String schemaName, ColumnTypeMapper typeMapper, TransactionManager transactionManager) {
        this.dialect = dialect;
        this.schemaName = schemaName;
        this.queryFactory = new QueryFactory(dialect, typeMapper);
        this.keyGenerator = KeyGeneratorFactory.create(dialect);
        this.queryRunnerFactory = new QueryRunnerFactory(transactionManager, this.keyGenerator);
        this.simpleQueryRunner = new SimpleQueryRunner(this.queryRunnerFactory);
        this.transactionRunner = new TransactionRunner(this.queryRunnerFactory);
        this.schemaManagerFactory = new SchemaManagerFactory(transactionManager, this.schemaName(), dialect);
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public Dialect dialect() {
        return this.dialect;
    }

    @Override
    public QueryFactory query() {
        return this.queryFactory;
    }

    @Override
    public QueryRunner queryRunner() {
        return this.queryRunnerFactory.create();
    }

    @Override
    public SimpleQueryRunner simpleQueryRunner() {
        return this.simpleQueryRunner;
    }

    @Override
    public TransactionRunner transactionRunner() {
        return this.transactionRunner;
    }

    @Override
    public SchemaManager schemaManager() {
        return this.schemaManagerFactory.createManager();
    }

    @Override
    public SchemaInspector schemaInspector() {
        return this.schemaManagerFactory.createInspector();
    }

    @Override
    public void rollback(QueryRunner ... toRollback) {
        TheCloser.rollback(toRollback);
    }

    @Override
    public void close(Closeable ... toClose) {
        TheCloser.close(toClose);
    }

    @Override
    public void resetKeyGeneratorCache() {
        this.keyGenerator.reset();
    }
}

