/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query;

import java.sql.SQLException;
import org.polyjdbc.core.key.KeyGenerator;
import org.polyjdbc.core.query.Query;
import org.polyjdbc.core.transaction.Transaction;
import org.polyjdbc.core.type.ColumnTypeMapper;
import org.polyjdbc.core.util.StringBuilderUtil;

public abstract class InsertQuery {
    private static final int VALUES_LENGTH = 50;
    private final Query query;
    private final StringBuilder valueNames = new StringBuilder(50);
    private final StringBuilder values = new StringBuilder(50);

    InsertQuery(ColumnTypeMapper typeMapper) {
        this.query = new Query(typeMapper);
    }

    Query build() {
        StringBuilderUtil.deleteLastCharacters(this.valueNames, 2);
        StringBuilderUtil.deleteLastCharacters(this.values, 2);
        this.query.append("(").append(this.valueNames.toString()).append(")").append(" VALUES(").append(this.values.toString()).append(")");
        this.query.compile();
        return this.query;
    }

    public InsertQuery into(String tableName) {
        this.query.append("INSERT INTO ").append(tableName);
        return this;
    }

    public abstract InsertQuery sequence(String var1, String var2);

    abstract boolean isIdInserted();

    abstract long generateSequenceValue(KeyGenerator var1, Transaction var2) throws SQLException;

    public InsertQuery value(String fieldName, Object value) {
        this.valueNames.append(fieldName).append(", ");
        this.values.append(":").append(fieldName).append(", ");
        this.setArgument(fieldName, value);
        return this;
    }

    void setArgument(String fieldName, Object value) {
        this.query.setArgument(fieldName, value);
    }
}

