/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query;

import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.Limit;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.Query;
import org.polyjdbc.core.type.ColumnTypeMapper;
import org.polyjdbc.core.util.StringBuilderUtil;

public class SelectQuery {
    private static final int ORDER_BY_LENGTH = 20;
    private final Dialect dialect;
    private final Query query;
    private StringBuilder orderBy;
    private Limit limit;

    SelectQuery(Dialect dialect, ColumnTypeMapper typeMapper, String what) {
        this(dialect, typeMapper);
        this.query.append("SELECT ").append(what).append(" ");
    }

    SelectQuery(Dialect dialect, ColumnTypeMapper typeMapper) {
        this.dialect = dialect;
        this.query = new Query(typeMapper);
    }

    Query build() {
        if (this.orderBy != null) {
            StringBuilderUtil.deleteLastCharacters(this.orderBy, 2);
            this.query.append(this.orderBy.toString());
        }
        if (this.limit != null) {
            this.dialect.queries().limit(this.query, this.limit, this.orderBy != null);
        }
        this.query.compile();
        return this.query;
    }

    public SelectQuery from(String from) {
        this.query.append("FROM ").append(from).append(" ");
        return this;
    }

    public SelectQuery where(String where) {
        this.query.append("WHERE ").append(where).append(" ");
        return this;
    }

    public SelectQuery query(String queryText) {
        this.query.overwrite(queryText);
        return this;
    }

    public SelectQuery append(String queryText) {
        this.query.append(queryText);
        return this;
    }

    public SelectQuery orderBy(String name, Order order) {
        if (this.orderBy == null) {
            this.orderBy = new StringBuilder(20);
            this.orderBy.append(" ORDER BY ");
        }
        this.orderBy.append(name).append(" ").append(order.getStringCode()).append(", ");
        return this;
    }

    public SelectQuery limit(int limit, int offset) {
        this.limit = new Limit(limit, offset);
        return this;
    }

    public SelectQuery limit(int limit) {
        return this.limit(limit, 0);
    }

    public SelectQuery withArgument(String argumentName, Object object) {
        this.query.setArgument(argumentName, object);
        return this;
    }
}

