/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.polyjdbc.core.exception.NonUniqueException;
import org.polyjdbc.core.exception.QueryExecutionException;
import org.polyjdbc.core.key.KeyGenerator;
import org.polyjdbc.core.query.DeleteQuery;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.InsertWithAutoincrement;
import org.polyjdbc.core.query.InsertWithSequence;
import org.polyjdbc.core.query.Query;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.UpdateQuery;
import org.polyjdbc.core.query.mapper.EmptyMapper;
import org.polyjdbc.core.query.mapper.ObjectMapper;
import org.polyjdbc.core.transaction.Transaction;

public class TransactionalQueryRunner
implements QueryRunner {
    private static final EmptyMapper EMPTY_MAPPER = new EmptyMapper();
    private final Transaction transaction;
    private final KeyGenerator keyGenerator;

    public TransactionalQueryRunner(Transaction transaction, KeyGenerator keyGenerator) {
        this.transaction = transaction;
        this.keyGenerator = keyGenerator;
    }

    @Override
    public <T> T queryUnique(SelectQuery query, ObjectMapper<T> mapper) {
        return this.queryUnique(query, mapper, true);
    }

    @Override
    public <T> T queryUnique(SelectQuery query, ObjectMapper<T> mapper, boolean failOnNotUniqueOrNotFound) {
        query.limit(2);
        Query rawQuery = query.build();
        List results = this.queryCollection(rawQuery, mapper, new ArrayList());
        if (results.size() != 1) {
            if (failOnNotUniqueOrNotFound) {
                this.transaction.rollback();
                if (results.isEmpty()) {
                    throw new NonUniqueException("NO_ITEM_FOUND", String.format("Asked for unique result but no items found for query:%n%s", rawQuery.getQuery()));
                }
                throw new NonUniqueException("NON_UNIQUE_ITEM", String.format("Asked for unique result but %d items found for query:%n%s", results.size(), rawQuery.getQuery()));
            }
            return null;
        }
        return (T)results.get(0);
    }

    @Override
    public <T> List<T> queryList(SelectQuery query, ObjectMapper<T> mapper) {
        return this.queryCollection(query.build(), mapper, new ArrayList());
    }

    @Override
    public <T> Set<T> querySet(SelectQuery query, ObjectMapper<T> mapper) {
        return this.queryCollection(query.build(), mapper, new HashSet());
    }

    /*
     * Exception decompiling
     */
    private <T, C extends Collection<T>> C queryCollection(Query query, ObjectMapper<T> mapper, C collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean queryExistence(SelectQuery query) {
        return !this.queryList(query, EMPTY_MAPPER).isEmpty();
    }

    @Override
    public long insert(InsertQuery insertQuery) {
        try {
            long key = 0L;
            if (insertQuery.isIdInserted() && insertQuery instanceof InsertWithSequence) {
                key = insertQuery.generateSequenceValue(this.keyGenerator, this.transaction);
            }
            Query rawQuery = insertQuery.build();
            try (PreparedStatement statement = rawQuery.createStatementWithValues(this.transaction);){
                this.transaction.executeUpdate(statement);
            }
            if (insertQuery.isIdInserted() && insertQuery instanceof InsertWithAutoincrement) {
                key = this.keyGenerator.getKeyFromLastInsert(this.transaction);
            }
            return key;
        }
        catch (SQLException exception) {
            this.transaction.rollback();
            Query rawQuery = insertQuery.build();
            throw new QueryExecutionException("INSERT_ERROR", String.format("Failed to run insert query:%n%s", rawQuery), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int update(UpdateQuery updateQuery) {
        Query rawQuery = updateQuery.build();
        try (PreparedStatement statement = rawQuery.createStatementWithValues(this.transaction);){
            int n = this.transaction.executeUpdate(statement);
            return n;
        }
        catch (SQLException exception) {
            this.transaction.rollback();
            throw new QueryExecutionException("UPDATE_ERROR", String.format("Failed to run update query:%n%s", rawQuery.getQuery()), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int delete(DeleteQuery deleteQuery) {
        Query rawQuery = deleteQuery.build();
        try (PreparedStatement statement = rawQuery.createStatementWithValues(this.transaction);){
            int n = this.transaction.executeUpdate(statement);
            return n;
        }
        catch (SQLException exception) {
            this.transaction.rollback();
            throw new QueryExecutionException("DELETE_ERROR", String.format("Failed to run delete query:%n%s", rawQuery.getQuery()), exception);
        }
    }

    @Override
    public void commit() {
        this.transaction.commit();
    }

    @Override
    public void rollback() {
        this.transaction.rollback();
    }

    @Override
    public void rollbackAndClose() {
        this.rollback();
        this.transaction.close();
    }

    @Override
    public void commitAndClose() {
        this.commit();
        this.transaction.close();
    }

    @Override
    public void close() {
        this.transaction.close();
    }
}

