/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.polyjdbc.core.exception.QueryLoaderException;
import org.polyjdbc.core.query.loader.QueryLoader;

public class ClasspathQueryLoader
implements QueryLoader {
    @Override
    public String getQuery(String resourceName) {
        BufferedReader fileStream = null;
        try {
            InputStream stream = this.getClass().getResourceAsStream(resourceName);
            if (stream == null) {
                throw new IOException("resource " + resourceName + " not found");
            }
            fileStream = new BufferedReader(new InputStreamReader(stream));
            String string = this.readAsString(fileStream);
            this.closeStream(fileStream);
            return string;
        }
        catch (IOException exception) {
            try {
                throw new QueryLoaderException("CLASSPATH_LOADING_ERROR", "Exception wile reading query from file " + resourceName, exception);
            }
            catch (Throwable throwable) {
                this.closeStream(fileStream);
                throw throwable;
            }
        }
    }

    private void closeStream(BufferedReader stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException exception) {
            throw new QueryLoaderException("RESOURCE_CLEANUP_ERROR", "Failed to close stream after reading schema definition!", exception);
        }
    }

    private String readAsString(BufferedReader source) throws IOException {
        StringWriter target = new StringWriter();
        String line = source.readLine();
        while (line != null) {
            target.write(line + "\n");
            line = source.readLine();
        }
        return target.toString();
    }
}

