/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.Markdown;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHtml2Generator
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(StaticHtml2Generator.class);
    protected String invokerPackage = "org.openapitools.client";
    protected String phpInvokerPackage = "OpenAPITools\\Client";
    protected String packageName = "Org.OpenAPITools";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-client";
    protected String artifactVersion = "1.0.0";
    protected String jsProjectName;
    protected String jsModuleName;
    protected String perlModuleName = "WWW::OPenAPIClient";
    protected String pythonPackageName = "openapi_client";

    public StaticHtml2Generator() {
        this.modifyFeatureSet(features -> features.documentationFeatures(EnumSet.allOf(DocumentationFeature.class)).dataTypeFeatures(EnumSet.allOf(DataTypeFeature.class)).wireFormatFeatures(EnumSet.allOf(WireFormatFeature.class)).securityFeatures(EnumSet.allOf(SecurityFeature.class)).globalFeatures(EnumSet.allOf(GlobalFeature.class)).parameterFeatures(EnumSet.allOf(ParameterFeature.class)).schemaSupportFeatures(EnumSet.allOf(SchemaSupportFeature.class)));
        this.outputFolder = "docs";
        this.templateDir = "htmlDocs2";
        this.embeddedTemplateDir = "htmlDocs2";
        this.defaultIncludes = new HashSet();
        this.cliOptions.add(new CliOption("appName", "short name of the application"));
        this.cliOptions.add(new CliOption("appDescription", "description of the application"));
        this.cliOptions.add(new CliOption("infoUrl", "a URL where users can get more information about the application"));
        this.cliOptions.add(new CliOption("infoEmail", "an email address to contact for inquiries about the application"));
        this.cliOptions.add(new CliOption("licenseInfo", "a short description of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "a URL pointing to the full license"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("phpInvokerPackage", "root package for generated php code"));
        this.cliOptions.add(new CliOption("perlModuleName", "root module name for generated perl code"));
        this.cliOptions.add(new CliOption("pythonPackageName", "package name for generated python code"));
        this.cliOptions.add(new CliOption("packageName", "C# package name"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml. This also becomes part of the generated library's filename"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename"));
        this.additionalProperties.put("appName", "OpenAPI Sample");
        this.additionalProperties.put("appDescription", "A sample OpenAPI server");
        this.additionalProperties.put("infoUrl", "https://openapi-generator.tech");
        this.additionalProperties.put("infoEmail", "team@openapitools.org");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("phpInvokerPackage", this.phpInvokerPackage);
        this.additionalProperties.put("perlModuleName", this.perlModuleName);
        this.additionalProperties.put("pythonPackageName", this.pythonPackageName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.html"));
        this.reservedWords = new HashSet();
        this.languageSpecificPrimitives = new HashSet();
        this.importMapping = new HashMap();
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "html2";
    }

    @Override
    public String escapeText(String input) {
        return input;
    }

    @Override
    public String getHelp() {
        return "Generates a static HTML file.";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            for (CodegenResponse response : op.responses) {
                if (!"0".equals(response.code)) continue;
                response.code = "default";
            }
            op.formParams = this.postProcessParameterEnum(op.formParams);
        }
        return objs;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.jsProjectName) && info.getTitle() != null) {
                this.jsProjectName = this.sanitizeName(StringUtils.dashize(info.getTitle()));
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.jsProjectName)) {
            this.jsProjectName = "openapi-js-client";
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.jsModuleName)) {
            this.jsModuleName = StringUtils.camelize(StringUtils.underscore(this.jsProjectName));
        }
        this.additionalProperties.put("jsProjectName", this.jsProjectName);
        this.additionalProperties.put("jsModuleName", this.jsModuleName);
        this.prepareHtmlForGlobalDescription(openAPI);
        Map vendorExtensions = openAPI.getExtensions();
        if (vendorExtensions != null) {
            for (Map.Entry vendorExtension : vendorExtensions.entrySet()) {
                if (vendorExtension.getValue() instanceof Map) {
                    this.vendorExtensions().put((String)vendorExtension.getKey(), Json.mapper().convertValue(vendorExtension.getValue(), JsonNode.class));
                    continue;
                }
                this.vendorExtensions().put((String)vendorExtension.getKey(), vendorExtension.getValue());
            }
        }
        openAPI.setExtensions(this.vendorExtensions);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (op.returnType != null) {
            op.returnType = this.normalizeType(op.returnType);
        }
        op.path = this.sanitizePath(op.path);
        String methodUpperCase = httpMethod.toUpperCase(Locale.ROOT);
        op.vendorExtensions.put("x-codegen-http-method-upper-case", methodUpperCase);
        return op;
    }

    private void prepareHtmlForGlobalDescription(OpenAPI openAPI) {
        if (openAPI.getInfo() == null) {
            return;
        }
        String currentDescription = openAPI.getInfo().getDescription();
        if (currentDescription != null && !currentDescription.isEmpty()) {
            Markdown markInstance = new Markdown();
            openAPI.getInfo().setDescription(markInstance.toHtml(currentDescription));
        } else {
            this.LOGGER.error("OpenAPI object description is empty [{}]", (Object)openAPI.getInfo().getTitle());
        }
    }

    public List<CodegenParameter> postProcessParameterEnum(List<CodegenParameter> parameterList) {
        String enumFormatted = "";
        for (CodegenParameter parameter : parameterList) {
            if (!parameter.isEnum) continue;
            for (int i = 0; i < parameter._enum.size(); ++i) {
                String spacer;
                String string = spacer = i == parameter._enum.size() - 1 ? " " : ", ";
                if (parameter._enum.get(i) == null) continue;
                enumFormatted = enumFormatted + "`" + parameter._enum.get(i) + "`" + spacer;
            }
            Markdown markInstance = new Markdown();
            if (enumFormatted.isEmpty()) continue;
            String formattedExtension = markInstance.toHtml(enumFormatted);
            parameter.vendorExtensions.put("x-eum-formatted", formattedExtension);
        }
        return parameterList;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("'", "%27");
    }

    public String normalizeType(String type) {
        return type.replaceAll("\\b(Boolean|Integer|Number|String|Date)\\b", "'$1'");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return null;
    }
}

