/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import reactor.netty.http.client.HttpClient;

@Configuration
public class ReactiveHttpClientsConfiguration {
    @Bean
    public ClientHttpConnector sslClientHttpConnector(SslContext sslContext) {
        HttpClient httpClient = HttpClient.create().secure(x -> x.sslContext(sslContext));
        return new ReactorClientHttpConnector(httpClient);
    }

    @Bean
    @ConditionalOnProperty(value={"atp-auth.ssl.certificate.verify"}, havingValue="false", matchIfMissing=true)
    public SslContext reactiveIgnoreVerifySslContext() throws Exception {
        return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
    }

    @Bean
    @ConditionalOnProperty(value={"atp-auth.ssl.certificate.verify"}, matchIfMissing=false)
    public SslContext reactiveSelfSignedSslContext(Provider<TrustManagerFactory> trustManagerFactoryProvider) throws Exception {
        return SslContextBuilder.forClient().trustManager(trustManagerFactoryProvider.get()).build();
    }
}

