/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.feign.exception;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.ErrorDecoder;
import feign.codec.StringDecoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import org.qubership.atp.auth.springbootstarter.feign.exception.FeignClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignClientExceptionErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignClientExceptionErrorDecoder.class);
    private final StringDecoder stringDecoder = new StringDecoder();

    public FeignClientException decode(String methodKey, Response response) {
        String message = "Null Response Body.";
        try {
            message = response.body() != null ? this.decode(response, (Type)((Object)String.class)).toString() : this.stringDecoder.decode(response, String.class).toString();
        }
        catch (IOException e) {
            log.error("{} Error Deserializing response body from failed feign request response.", (Object)methodKey, (Object)e);
        }
        return new FeignClientException(response.status(), message, response.request().httpMethod(), response.headers(), response.request());
    }

    private Object decode(Response response, Type type) throws IOException {
        Response.Body body = response.body();
        if (String.class.equals((Object)type)) {
            return Util.toString((Reader)body.asReader(Util.UTF_8));
        }
        throw new DecodeException(response.status(), String.format("%s is not a type supported by this decoder.", type), response.request());
    }
}

