/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.visitors;

import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.github.curiousoddman.rgxgen.nodes.Choice;
import com.github.curiousoddman.rgxgen.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.nodes.Group;
import com.github.curiousoddman.rgxgen.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.nodes.Node;
import com.github.curiousoddman.rgxgen.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.nodes.Repeat;
import com.github.curiousoddman.rgxgen.nodes.Sequence;
import com.github.curiousoddman.rgxgen.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.visitors.GenerationVisitorBuilder;
import com.github.curiousoddman.rgxgen.visitors.NodeVisitor;
import com.github.curiousoddman.rgxgen.visitors.NotMatchingGenerationVisitor;
import java.util.Map;
import java.util.Random;

public class GenerationVisitor
implements NodeVisitor {
    protected final StringBuilder aStringBuilder = new StringBuilder();
    protected final Map<Integer, String> aGroupValues;
    protected final Random aRandom;
    protected final RgxGenProperties aProperties;

    public static GenerationVisitorBuilder builder() {
        return new GenerationVisitorBuilder(true);
    }

    protected GenerationVisitor(Random random, Map<Integer, String> groupValues, RgxGenProperties properties) {
        this.aRandom = random;
        this.aGroupValues = groupValues;
        this.aProperties = properties;
    }

    @Override
    public void visit(SymbolSet node) {
        Character[] allSymbols = node.getSymbols();
        int idx = this.aRandom.nextInt(allSymbols.length);
        this.aStringBuilder.append(allSymbols[idx]);
    }

    @Override
    public void visit(Choice node) {
        Node[] nodes = node.getNodes();
        int idx = this.aRandom.nextInt(nodes.length);
        nodes[idx].visit(this);
    }

    @Override
    public void visit(FinalSymbol node) {
        this.aStringBuilder.append(node.getValue());
    }

    @Override
    public void visit(Repeat node) {
        int max = node.getMax() == -1 ? RgxGenOption.INFINITE_PATTERN_REPETITION.getIntFromProperties(this.aProperties) : node.getMax();
        int repeat = node.getMin() >= max ? node.getMin() : node.getMin() + this.aRandom.nextInt(max + 1 - node.getMin());
        for (int i = 0; i < repeat; ++i) {
            node.getNode().visit(this);
        }
    }

    @Override
    public void visit(Sequence node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    @Override
    public void visit(NotSymbol node) {
        NotMatchingGenerationVisitor nmgv = new NotMatchingGenerationVisitor(this.aRandom, this.aGroupValues, this.aProperties);
        node.getNode().visit(nmgv);
        this.aStringBuilder.append((CharSequence)nmgv.aStringBuilder);
    }

    @Override
    public void visit(GroupRef node) {
        this.aStringBuilder.append(this.aGroupValues.getOrDefault(node.getIndex(), ""));
    }

    @Override
    public void visit(Group node) {
        int start = this.aStringBuilder.length();
        node.getNode().visit(this);
        this.aGroupValues.put(node.getIndex(), this.aStringBuilder.substring(start));
    }

    public String getString() {
        return this.aStringBuilder.toString();
    }
}

