/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import java.util.Objects;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.Atomic;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.PropertyChangeMetadata;

public class ValueChange
extends PropertyChange<Object> {
    private final Atomic left;
    private final Atomic right;

    public ValueChange(PropertyChangeMetadata metadata, Object leftValue, Object rightValue) {
        super(metadata);
        this.left = new Atomic(leftValue);
        this.right = new Atomic(rightValue);
    }

    @Override
    public Object getLeft() {
        return this.left.unwrap();
    }

    @Override
    public Object getRight() {
        return this.right.unwrap();
    }

    @Override
    public String prettyPrint(PrettyValuePrinter valuePrinter) {
        Validate.argumentIsNotNull(valuePrinter);
        if (this.isPropertyAdded()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " property with value " + valuePrinter.formatWithQuotes(this.right.unwrap()) + " added";
        }
        if (this.isPropertyRemoved()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " property with value " + valuePrinter.formatWithQuotes(this.left.unwrap()) + " removed";
        }
        if (this.left.isNull()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " = " + valuePrinter.formatWithQuotes(this.getRight());
        }
        if (this.right.isNull()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " value " + valuePrinter.formatWithQuotes(this.getLeft()) + " unset";
        }
        return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " changed: " + valuePrinter.formatWithQuotes(this.getLeft()) + " -> " + valuePrinter.formatWithQuotes(this.getRight());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ValueChange) {
            ValueChange that = (ValueChange)obj;
            return super.equals(that) && Objects.equals(this.getLeft(), that.getLeft()) && Objects.equals(this.getRight(), that.getRight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLeft(), this.getRight());
    }

    @Override
    public String toString() {
        PrettyValuePrinter printer = PrettyValuePrinter.getDefault();
        return this.getClass().getSimpleName() + "{ property: '" + this.getPropertyName() + "', left:" + printer.formatWithQuotes(this.getLeft()) + ",  right:" + printer.formatWithQuotes(this.getRight()) + " }";
    }
}

