/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.monitoring.undertow.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.lang.NonNull;
import io.undertow.server.handlers.MetricsHandler;
import java.util.Collections;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowMeterBinder;

public class UndertowRequestMetrics
extends UndertowMeterBinder {
    private static final String METRIC_NAME_REQUESTS = ".request.count";
    private static final String METRIC_NAME_REQUEST_ERRORS = ".request.errors";
    private static final String METRIC_NAME_REQUEST_TIME_MAX = ".request.time.max";
    private static final String METRIC_NAME_REQUEST_TIME_MIN = ".request.time.min";
    private final MetricsHandler undertowMetricsHandler;
    private final String namePrefix;
    private final Iterable<Tag> tags;

    public UndertowRequestMetrics(MetricsHandler undertowMetricsHandler) {
        this(undertowMetricsHandler, "undertow");
    }

    public UndertowRequestMetrics(MetricsHandler undertowMetricsHandler, String namePrefix) {
        this(undertowMetricsHandler, namePrefix, Collections.emptyList());
    }

    public UndertowRequestMetrics(MetricsHandler undertowMetricsHandler, String namePrefix, Iterable<Tag> tags) {
        this.undertowMetricsHandler = undertowMetricsHandler;
        this.namePrefix = namePrefix;
        this.tags = tags;
    }

    public void bindTo(@NonNull MeterRegistry registry) {
        this.bindTimer(registry, this.namePrefix + METRIC_NAME_REQUESTS, "Number of total requests", this.undertowMetricsHandler, m -> m.getMetrics().getTotalRequests(), m2 -> m2.getMetrics().getMinRequestTime(), this.tags);
        this.bindTimeGauge(registry, this.namePrefix + METRIC_NAME_REQUEST_TIME_MAX, "The longest request duration in time", this.undertowMetricsHandler, m -> m.getMetrics().getMaxRequestTime(), this.tags);
        this.bindTimeGauge(registry, this.namePrefix + METRIC_NAME_REQUEST_TIME_MIN, "The shortest request duration in time", this.undertowMetricsHandler, m -> m.getMetrics().getMinRequestTime(), this.tags);
        this.bindCounter(registry, this.namePrefix + METRIC_NAME_REQUEST_ERRORS, "Total number of error requests ", this.undertowMetricsHandler, m -> m.getMetrics().getTotalErrors(), this.tags);
    }
}

