/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.spring;

import java.sql.Connection;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringConnectionProvider
implements Supplier<Connection> {
    private final DataSource dataSource;

    public SpringConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Connection get() {
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        if (!DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
            throw new IllegalStateException("Connection is not transactional");
        }
        return connection;
    }
}

