/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.clients.api.catalogue.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.clients.api.catalogue.generated.CompoundDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestPlanResponseDto;
import org.springframework.format.annotation.DateTimeFormat;

@JsonTypeName(value="QaDslLibraryResponse")
public class QaDslLibraryResponseDto {
    @JsonProperty(value="compounds")
    @Valid
    private List<CompoundDto> compounds = null;
    @JsonProperty(value="modifiedWhen")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime modifiedWhen;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="qaDslLibraryId")
    private UUID qaDslLibraryId;
    @JsonProperty(value="testPlan")
    @Valid
    private List<TestPlanResponseDto> testPlan = null;

    public QaDslLibraryResponseDto compounds(List<CompoundDto> compounds) {
        this.compounds = compounds;
        return this;
    }

    public QaDslLibraryResponseDto addCompoundsItem(CompoundDto compoundsItem) {
        if (this.compounds == null) {
            this.compounds = new ArrayList<CompoundDto>();
        }
        this.compounds.add(compoundsItem);
        return this;
    }

    @Valid
    @Schema(name="compounds", required=false)
    public List<CompoundDto> getCompounds() {
        return this.compounds;
    }

    public void setCompounds(List<CompoundDto> compounds) {
        this.compounds = compounds;
    }

    public QaDslLibraryResponseDto modifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
        return this;
    }

    @Valid
    @Schema(name="modifiedWhen", required=false)
    public OffsetDateTime getModifiedWhen() {
        return this.modifiedWhen;
    }

    public void setModifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public QaDslLibraryResponseDto name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QaDslLibraryResponseDto qaDslLibraryId(UUID qaDslLibraryId) {
        this.qaDslLibraryId = qaDslLibraryId;
        return this;
    }

    @Valid
    @Schema(name="qaDslLibraryId", required=false)
    public UUID getQaDslLibraryId() {
        return this.qaDslLibraryId;
    }

    public void setQaDslLibraryId(UUID qaDslLibraryId) {
        this.qaDslLibraryId = qaDslLibraryId;
    }

    public QaDslLibraryResponseDto testPlan(List<TestPlanResponseDto> testPlan) {
        this.testPlan = testPlan;
        return this;
    }

    public QaDslLibraryResponseDto addTestPlanItem(TestPlanResponseDto testPlanItem) {
        if (this.testPlan == null) {
            this.testPlan = new ArrayList<TestPlanResponseDto>();
        }
        this.testPlan.add(testPlanItem);
        return this;
    }

    @Valid
    @Schema(name="testPlan", required=false)
    public List<TestPlanResponseDto> getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(List<TestPlanResponseDto> testPlan) {
        this.testPlan = testPlan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QaDslLibraryResponseDto qaDslLibraryResponse = (QaDslLibraryResponseDto)o;
        return Objects.equals(this.compounds, qaDslLibraryResponse.compounds) && Objects.equals(this.modifiedWhen, qaDslLibraryResponse.modifiedWhen) && Objects.equals(this.name, qaDslLibraryResponse.name) && Objects.equals(this.qaDslLibraryId, qaDslLibraryResponse.qaDslLibraryId) && Objects.equals(this.testPlan, qaDslLibraryResponse.testPlan);
    }

    public int hashCode() {
        return Objects.hash(this.compounds, this.modifiedWhen, this.name, this.qaDslLibraryId, this.testPlan);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QaDslLibraryResponseDto {\n");
        sb.append("    compounds: ").append(this.toIndentedString(this.compounds)).append("\n");
        sb.append("    modifiedWhen: ").append(this.toIndentedString(this.modifiedWhen)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    qaDslLibraryId: ").append(this.toIndentedString(this.qaDslLibraryId)).append("\n");
        sb.append("    testPlan: ").append(this.toIndentedString(this.testPlan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

