/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.config;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.qubership.atp.environments.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpClientConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConfig.class);
    @Value(value="${atp-environments.get.version.httpclient.socketTimeout}")
    private int socketTimeout;
    @Value(value="${atp-environments.get.version.httpclient.maxTotal}")
    private int maxTotal;
    @Value(value="${atp-environments.get.version.httpclient.defaultMaxPerRoute}")
    private int defaultMaxPerRoute;

    @Bean
    public CloseableHttpClient httpClient() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return HttpUtils.createTrustAllHttpClientBuilder().setDefaultRequestConfig(this.requestConfig(this.socketTimeout)).setConnectionManager(this.connectionManager()).build();
    }

    private HttpClientConnectionManager connectionManager() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
        connectionManager.setMaxTotal(this.maxTotal);
        connectionManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        return connectionManager;
    }

    private RequestConfig requestConfig(int socketTimeout) {
        log.debug("Configure RequestConfig [socketTimeout={}]", (Object)socketTimeout);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(socketTimeout * 1000).build();
        return config;
    }
}

