/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfig {
    private static final String THREAD_NAME_PREFIX = "ArchiveJob-";
    @Value(value="${atp-environments.archive.job.thread.max-pool-size}")
    private Integer maxPoolSize;
    @Value(value="${atp-environments.archive.job.thread.core-pool-size}")
    private Integer corePoolSize;
    @Value(value="${atp-environments.archive.job.thread.queue-capacity}")
    private Integer queueCapacity;

    @Bean
    public ThreadPoolTaskExecutor archiveJobExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(this.maxPoolSize.intValue());
        executor.setCorePoolSize(this.corePoolSize.intValue());
        executor.setQueueCapacity(this.queueCapacity.intValue());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setThreadNamePrefix(THREAD_NAME_PREFIX);
        executor.initialize();
        return executor;
    }
}

