/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.modification;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.aopalliance.intercept.Joinpoint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.qubership.atp.environments.db.modification.AbstractNotifier;
import org.qubership.atp.environments.db.modification.EntityTypeStrategy;
import org.qubership.atp.environments.db.modification.TrackedMethod;
import org.qubership.atp.environments.db.modification.TrackedType;
import org.qubership.atp.environments.db.modification.afterbefore.CreateStrategy;
import org.qubership.atp.environments.db.modification.afterbefore.DeleteStrategy;
import org.qubership.atp.environments.db.modification.afterbefore.TrackedMethodStrategy;
import org.qubership.atp.environments.db.modification.afterbefore.UpdateStrategy;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.utils.tree.AllRefsIterator;
import org.qubership.atp.environments.service.direct.ConnectionService;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.SubscriptionService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.direct.UpdateEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class ModificationInterceptor
implements MethodInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(ModificationInterceptor.class);
    private final Map<Class, Handler> handlers = new ConcurrentHashMap<Class, Handler>();
    @Autowired
    @Lazy
    private SubscriptionService subscriptionService;
    @Autowired
    private UpdateEventService updateEventService;
    @Autowired
    @Lazy
    private SystemService systemService;
    @Autowired
    @Lazy
    private ConnectionService connectionService;
    @Autowired
    @Lazy
    private EnvironmentService environmentService;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        return this.handlers.computeIfAbsent(methodInvocation.getThis().getClass(), this::createHandler).apply(methodInvocation);
    }

    private Handler createHandler(Class clazz) {
        ClassHierarchy allClasses = new ClassHierarchy(clazz);
        Optional targetServiceOpt = Iterators.tryFind((Iterator)((Object)allClasses), someClass -> someClass.getSimpleName().endsWith("Service")).toJavaUtil();
        if (!targetServiceOpt.isPresent()) {
            return Joinpoint::proceed;
        }
        Class targetService = (Class)targetServiceOpt.get();
        String targetServiceName = targetService.getSimpleName();
        String entityName = targetServiceName.substring(0, targetServiceName.length() - "Service".length());
        Optional<TrackedType> trackedTypeOpt = TrackedType.getByName(entityName);
        return trackedTypeOpt.map(x$0 -> new Notifier((TrackedType)((Object)x$0))).orElse(Joinpoint::proceed);
    }

    private static interface Handler {
        public Object apply(MethodInvocation var1) throws Throwable;
    }

    private static class ClassHierarchy
    extends AllRefsIterator<Class> {
        public ClassHierarchy(Class clazz) {
            super((Iterator)Iterators.singletonIterator((Object)clazz), false);
        }

        protected Iterator<? extends Class> getChildren(@Nonnull Class parent) {
            return Stream.concat(Arrays.stream(parent.getInterfaces()), Stream.of(parent.getSuperclass())).filter(Objects::nonNull).iterator();
        }
    }

    private class Notifier
    implements Handler {
        private final TrackedType trackedType;

        private Notifier(TrackedType trackedType) {
            this.trackedType = trackedType;
        }

        @Override
        public Object apply(MethodInvocation methodInvocation) throws Throwable {
            TrackedMethodStrategy strategy;
            AbstractNotifier entityStrategy;
            Class<?> returnType = methodInvocation.getMethod().getReturnType();
            Optional<TrackedMethod> trackedMethodOpt = TrackedMethod.getByName(methodInvocation.getMethod().getName());
            if (!trackedMethodOpt.isPresent()) {
                return methodInvocation.proceed();
            }
            TrackedMethod trackedMethod = trackedMethodOpt.get();
            switch (this.trackedType) {
                case PROJECT: {
                    entityStrategy = new ProjectNotifier(ModificationInterceptor.this.updateEventService, ModificationInterceptor.this.subscriptionService, trackedMethod);
                    break;
                }
                case ENVIRONMENT: {
                    entityStrategy = new EnvironmentNotifier(ModificationInterceptor.this.updateEventService, ModificationInterceptor.this.subscriptionService, trackedMethod);
                    break;
                }
                case SYSTEM: {
                    entityStrategy = new SystemNotifier(ModificationInterceptor.this.updateEventService, ModificationInterceptor.this.subscriptionService, trackedMethod);
                    break;
                }
                case CONNECTION: {
                    entityStrategy = new ConnectionNotifier(ModificationInterceptor.this.updateEventService, ModificationInterceptor.this.subscriptionService, trackedMethod);
                    break;
                }
                default: {
                    return methodInvocation.proceed();
                }
            }
            switch (trackedMethod) {
                case CREATE: {
                    if (!this.trackedType.entityType.isAssignableFrom(returnType) && !UUID.class.isAssignableFrom(returnType)) {
                        return methodInvocation.proceed();
                    }
                    strategy = new CreateStrategy(ModificationInterceptor.this, (EntityTypeStrategy)((Object)entityStrategy));
                    break;
                }
                case UPDATE: {
                    strategy = new UpdateStrategy(ModificationInterceptor.this, (EntityTypeStrategy)((Object)entityStrategy));
                    break;
                }
                case DELETE: {
                    strategy = new DeleteStrategy(ModificationInterceptor.this, (EntityTypeStrategy)((Object)entityStrategy));
                    break;
                }
                default: {
                    return methodInvocation.proceed();
                }
            }
            return strategy.proceed(methodInvocation);
        }
    }

    public static class ConnectionNotifier
    extends AbstractNotifier
    implements EntityTypeStrategy {
        public ConnectionNotifier(UpdateEventService updateEventService, SubscriptionService subscriptionService, TrackedMethod method) {
            super(updateEventService, subscriptionService, method, TrackedType.CONNECTION);
        }

        @Override
        public Runnable prepareNotification(UUID connectionId, ModificationInterceptor interceptor) {
            UUID systemId = ((Connection)interceptor.connectionService.get(connectionId)).getSystemId();
            List listEnvironment = ((System)interceptor.systemService.get(systemId)).getEnvironments();
            return () -> {
                LOG.info("{} object with id {} {}", new Object[]{TrackedType.CONNECTION, connectionId, this.method.getName()});
                ArrayList<UUID> listIdCascadeSubscriptionsForEnvironment = new ArrayList();
                ArrayList<UUID> listIdSubscriptionsForSystem = new ArrayList();
                ArrayList<UUID> listIdCascadeSubscriptionsForProject = new ArrayList();
                for (Environment environment : listEnvironment) {
                    UUID environmentId = environment.getId();
                    UUID projectId = environment.getProjectId();
                    listIdSubscriptionsForSystem = this.subscriptionService.getListIdSubscriptionsForSystem(systemId);
                    listIdCascadeSubscriptionsForProject = this.subscriptionService.getListIdSubscriptionsForProject(projectId, true);
                    listIdCascadeSubscriptionsForEnvironment = this.subscriptionService.getListIdSubscriptionsForEnvironment(environmentId, true);
                    List<UUID> listIdSubscriptionsForProject = this.subscriptionService.getListIdSubscriptionsForProject(projectId);
                    this.notifyUpdateEntity(listIdSubscriptionsForProject, projectId, TrackedType.PROJECT);
                    List<UUID> listIdSubscriptionsForEnvironment = this.subscriptionService.getListIdSubscriptionsForEnvironment(environmentId);
                    this.notifyUpdateEntity(listIdSubscriptionsForEnvironment, environmentId, TrackedType.ENVIRONMENT);
                    this.notifyUpdateEntity(listIdSubscriptionsForSystem, systemId, TrackedType.SYSTEM);
                    this.notifyUpdateEntity(listIdCascadeSubscriptionsForProject, systemId, TrackedType.SYSTEM);
                    this.notifyUpdateEntity(listIdCascadeSubscriptionsForEnvironment, systemId, TrackedType.SYSTEM);
                }
            };
        }
    }

    public static class SystemNotifier
    extends AbstractNotifier
    implements EntityTypeStrategy {
        public SystemNotifier(UpdateEventService updateEventService, SubscriptionService subscriptionService, TrackedMethod method) {
            super(updateEventService, subscriptionService, method, TrackedType.SYSTEM);
        }

        @Override
        public Runnable prepareNotification(UUID systemId, ModificationInterceptor interceptor) {
            List listEnvironment = ((System)interceptor.systemService.get(systemId)).getEnvironments();
            return () -> {
                LOG.info("{} object with id {} {}", new Object[]{TrackedType.SYSTEM, systemId, this.method.getName()});
                ArrayList<UUID> listIdCascadeSubscriptionsForProject = new ArrayList();
                ArrayList<UUID> listIdCascadeSubscriptionsForEnvironment = new ArrayList();
                for (Environment environment : listEnvironment) {
                    UUID environmentId = environment.getId();
                    UUID projectId = environment.getProjectId();
                    listIdCascadeSubscriptionsForProject = this.subscriptionService.getListIdSubscriptionsForProject(projectId, true);
                    listIdCascadeSubscriptionsForEnvironment = this.subscriptionService.getListIdSubscriptionsForEnvironment(environmentId, true);
                    List<UUID> listIdSubscriptionsForSystem = this.subscriptionService.getListIdSubscriptionsForSystem(systemId);
                    List<UUID> listIdSubscriptionsForProject = this.subscriptionService.getListIdSubscriptionsForProject(projectId);
                    this.notifyUpdateEntity(listIdSubscriptionsForProject, projectId, TrackedType.PROJECT);
                    List<UUID> listIdSubscriptionsForEnvironment = this.subscriptionService.getListIdSubscriptionsForEnvironment(environmentId);
                    this.notifyUpdateEntity(listIdSubscriptionsForEnvironment, environmentId, TrackedType.ENVIRONMENT);
                    this.notifyUpdateCurrentEntity(listIdSubscriptionsForSystem, systemId);
                    this.notifyUpdateCurrentEntity(listIdCascadeSubscriptionsForProject, systemId);
                    this.notifyUpdateCurrentEntity(listIdCascadeSubscriptionsForEnvironment, systemId);
                }
            };
        }
    }

    public static class EnvironmentNotifier
    extends AbstractNotifier
    implements EntityTypeStrategy {
        public EnvironmentNotifier(UpdateEventService updateEventService, SubscriptionService subscriptionService, TrackedMethod method) {
            super(updateEventService, subscriptionService, method, TrackedType.ENVIRONMENT);
        }

        public void notifySystemCascadeDelete(UUID systemId) {
            this.changeStatusEntitiesUpdateEvents(this.subscriptionService.getListIdSubscriptionsForSystem(systemId), systemId, TrackedMethod.DELETE, TrackedType.SYSTEM);
        }

        @Override
        public Runnable prepareNotification(UUID environmentId, ModificationInterceptor interceptor) throws Exception {
            UUID projectId = ((Environment)interceptor.environmentService.get(environmentId)).getProjectId();
            List<UUID> listIdSubscriptionsForEnvironment = this.subscriptionService.getListIdSubscriptionsForEnvironment(environmentId);
            List<System> systems = interceptor.environmentService.getSystems(environmentId);
            List<UUID> listIdCascadeSubscriptionsForProject = this.subscriptionService.getListIdSubscriptionsForProject(projectId, true);
            return () -> {
                LOG.info("{} object with id {} {}", new Object[]{TrackedType.ENVIRONMENT, environmentId, this.method.getName()});
                List<UUID> listIdSubscriptionsForProject = this.subscriptionService.getListIdSubscriptionsForProject(projectId);
                this.notifyUpdateEntity(listIdSubscriptionsForProject, projectId, TrackedType.PROJECT);
                this.notifyUpdateCurrentEntity(listIdSubscriptionsForEnvironment, environmentId);
                if (TrackedMethod.DELETE.equals((Object)this.method)) {
                    for (System anySystem : systems) {
                        UUID idSystem = anySystem.getId();
                        this.notifySystemCascadeDelete(idSystem);
                    }
                }
                this.notifyUpdateEntity(listIdCascadeSubscriptionsForProject, environmentId, TrackedType.ENVIRONMENT);
            };
        }
    }

    public static class ProjectNotifier
    extends AbstractNotifier
    implements EntityTypeStrategy {
        public ProjectNotifier(UpdateEventService updateEventService, SubscriptionService subscriptionService, TrackedMethod method) {
            super(updateEventService, subscriptionService, method, TrackedType.PROJECT);
        }

        @Override
        public Runnable prepareNotification(UUID projectId, ModificationInterceptor interceptor) throws Exception {
            List<UUID> listIdSubscriptionsForProject = this.subscriptionService.getListIdSubscriptionsForProject(projectId);
            return () -> {
                LOG.info("{} object with id {} {}", new Object[]{this.type, projectId, this.method.getName()});
                this.notifyUpdateCurrentEntity(listIdSubscriptionsForProject, projectId);
            };
        }
    }
}

