/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.ei;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.dto.validation.UserMessage;
import org.qubership.atp.environments.ei.service.EnvironmentsImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentsImportExecutor
implements ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsImportExecutor.class);
    private final EnvironmentsImporter environmentsImporter;

    public void importData(ExportImportData importData, Path workDir) throws Exception {
        log.info("Starts importData(importData: {}, workDir: {}).", (Object)importData, (Object)workDir);
        this.environmentsImporter.importEnvironments(workDir, importData);
        log.info("End of importData().");
    }

    public ValidationResult preValidateData(ExportImportData exportImportData, Path workDir) throws Exception {
        log.info("Starting environments pre validation(workDir: {})", (Object)workDir);
        List<String> messages = this.environmentsImporter.preValidateEnvironments(workDir, exportImportData.isInterProjectImport(), exportImportData.getReplacementMap());
        return new ValidationResult(messages.stream().map(UserMessage::new).collect(Collectors.toList()), new HashMap(exportImportData.getReplacementMap()));
    }

    public ValidationResult validateData(ExportImportData importData, Path workDir) throws Exception {
        HashMap<UUID, UUID> repMap = new HashMap<UUID, UUID>(importData.getReplacementMap());
        ArrayList<String> messages = new ArrayList<String>();
        if (importData.isImportFirstTime()) {
            log.info("validate will be skipped, because isImportFirstTime = true");
        } else if (importData.isCreateNewProject()) {
            this.handleCreateNewProjectValidation(workDir, repMap);
        } else if (importData.isInterProjectImport()) {
            this.handleInterProjectImportValidation(workDir, messages, repMap);
        } else {
            this.handleImportInTheSameProjectValidation(workDir, messages, repMap);
        }
        ArrayList details = new ArrayList();
        if (CollectionUtils.isNotEmpty(messages)) {
            details.addAll(messages.stream().map(UserMessage::new).collect(Collectors.toList()));
        }
        return new ValidationResult(details, repMap);
    }

    private void handleImportInTheSameProjectValidation(Path workDir, List<String> messages, Map<UUID, UUID> repMap) {
        messages.addAll(this.environmentsImporter.validateEnvironments(workDir, false, repMap));
    }

    private void handleInterProjectImportValidation(Path workDir, List<String> messages, Map<UUID, UUID> repMap) {
        this.environmentsImporter.fillRepMapWithSourceTargetValues(repMap, workDir);
        repMap.entrySet().forEach(entry -> {
            if (entry.getValue() == null) {
                entry.setValue(UUID.randomUUID());
            }
        });
        messages.addAll(this.environmentsImporter.validateEnvironments(workDir, true, repMap));
    }

    private void handleCreateNewProjectValidation(Path workDir, Map<UUID, UUID> repMap) {
        ArrayList<UUID> allIds = new ArrayList<UUID>(this.environmentsImporter.getObjectIds(workDir));
        allIds.forEach(id -> repMap.put((UUID)id, UUID.randomUUID()));
    }

    public EnvironmentsImportExecutor(EnvironmentsImporter environmentsImporter) {
        this.environmentsImporter = environmentsImporter;
    }
}

