/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.mapper;

import java.util.Objects;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.qubership.atp.environments.mapper.Mapper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMapper<S, D>
implements Mapper<S, D> {
    @Autowired
    protected ModelMapper mapper;
    protected Class<S> sourceClass;
    protected Class<D> destinationClass;

    public AbstractMapper(Class<S> sourceClass, Class<D> destinationClass) {
        this.sourceClass = sourceClass;
        this.destinationClass = destinationClass;
    }

    @Override
    public D map(S source) {
        return (D)(Objects.nonNull(source) ? this.mapper.map(source, this.destinationClass) : null);
    }

    Converter<S, D> mapConverter() {
        return context -> {
            Object source = context.getSource();
            Object destination = context.getDestination();
            this.mapSpecificFields(source, destination);
            return context.getDestination();
        };
    }

    abstract void mapSpecificFields(S var1, D var2);
}

