/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.model.Alert;
import org.qubership.atp.environments.model.AlertEvent;
import org.qubership.atp.environments.model.impl.AlertEventImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.AlertRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AlertEventRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final Provider<AlertRepositoryImpl> alertRepo;
    private final AlertEventProjection projection = new AlertEventProjection(this);

    @Autowired
    public AlertEventRepositoryImpl(SQLQueryFactory queryFactory, Provider<AlertRepositoryImpl> alertRepo) {
        this.queryFactory = queryFactory;
        this.alertRepo = alertRepo;
    }

    @Nonnull
    public List<AlertEvent> getAllByParentId(@Nonnull UUID alertId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ALERT_EVENTS)).where((Predicate)AlertEventRepositoryImpl.ALERT_EVENTS.alertId.eq((Object)alertId))).fetch();
    }

    @Nullable
    public AlertEvent getById(@Nonnull UUID alertId, @Nonnull UUID entityId) {
        return (AlertEvent)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ALERT_EVENTS)).where((Predicate)AlertEventRepositoryImpl.ALERT_EVENTS.alertId.eq((Object)alertId).and((Predicate)AlertEventRepositoryImpl.ALERT_EVENTS.entityId.eq((Object)entityId)))).fetchOne();
    }

    @Nonnull
    public List<AlertEvent> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ALERT_EVENTS)).fetch();
    }

    @Nonnull
    public AlertEvent create(@Nonnull UUID alertId, @Nonnull UUID entityId, String tagList, Integer status, Long lastUpdated) {
        Timestamp lastUpdatedTimestamp = new Timestamp(lastUpdated);
        long create = ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ALERT_EVENTS).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.alertId, (Object)alertId)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.entityId, (Object)entityId)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.tagList, (Object)tagList)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.status, (Object)status)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.lastUpdated, (Object)lastUpdatedTimestamp)).execute();
        Preconditions.checkArgument((create > 0L ? 1 : 0) != 0, (Object)"Nothing create");
        return this.projection.create(alertId, entityId, tagList, status, lastUpdatedTimestamp);
    }

    @Nonnull
    public AlertEvent update(@Nonnull UUID alertId, @Nonnull UUID entityId, String tagList, Integer status, Long lastUpdated) {
        Timestamp lastUpdatedTimestamp = new Timestamp(lastUpdated);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ALERT_EVENTS).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.alertId, (Object)alertId)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.entityId, (Object)entityId)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.tagList, (Object)tagList)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.status, (Object)status)).set((Path)AlertEventRepositoryImpl.ALERT_EVENTS.lastUpdated, (Object)lastUpdatedTimestamp)).where((Predicate)AlertEventRepositoryImpl.ALERT_EVENTS.alertId.eq((Object)alertId).and((Predicate)AlertEventRepositoryImpl.ALERT_EVENTS.entityId.eq((Object)entityId)))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        return this.projection.create(alertId, entityId, tagList, status, lastUpdatedTimestamp);
    }

    public void delete(@Nonnull UUID alertId, UUID entityId) {
        this.deleteReferenceToTable(alertId, entityId, (RelationalPathBase)ALERT_EVENTS, (SimplePath<UUID>)AlertEventRepositoryImpl.ALERT_EVENTS.alertId, (SimplePath<UUID>)AlertEventRepositoryImpl.ALERT_EVENTS.entityId);
    }

    private void deleteReferenceToTable(@Nonnull UUID alertId, UUID entityId, RelationalPathBase path, SimplePath<UUID> simplePathSubscriber, SimplePath<UUID> simplePathEntity) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePathSubscriber.eq((Object)alertId).and((Predicate)simplePathEntity.eq((Object)entityId)))).execute();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class AlertEventProjection
    extends MappingProjection<AlertEvent> {
        private static final long serialVersionUID = 42L;
        private final transient AlertEventRepositoryImpl repo;

        public AlertEventProjection(AlertEventRepositoryImpl repo) {
            super(AlertEvent.class, (Expression[])AbstractRepository.ALERT_EVENTS.all());
            this.repo = repo;
        }

        protected AlertEvent map(Tuple tuple) {
            UUID alertId = (UUID)tuple.get((Expression)AbstractRepository.ALERT_EVENTS.alertId);
            assert (alertId != null);
            UUID entityId = (UUID)tuple.get((Expression)AbstractRepository.ALERT_EVENTS.entityId);
            assert (entityId != null);
            String tagList = (String)tuple.get((Expression)AbstractRepository.ALERT_EVENTS.tagList);
            Integer status = (Integer)tuple.get((Expression)AbstractRepository.ALERT_EVENTS.status);
            Timestamp lastUpdated = (Timestamp)tuple.get((Expression)AbstractRepository.ALERT_EVENTS.lastUpdated);
            assert (lastUpdated != null);
            return this.create(alertId, entityId, tagList, status, lastUpdated);
        }

        protected AlertEventImpl create(UUID alertId, UUID entityId, String tagList, Integer status, Timestamp lastUpdated) {
            Alert alertAsObj = ((AlertRepositoryImpl)this.repo.alertRepo.get()).getById(alertId);
            return new AlertEventImpl(alertAsObj, alertId, entityId, tagList, status, Long.valueOf(lastUpdated.getTime()));
        }
    }
}

