/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.db.Proxies;
import org.qubership.atp.environments.model.Subscriber;
import org.qubership.atp.environments.model.impl.SubscriberImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.SubscriptionRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SubscriberRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final Provider<SubscriptionRepositoryImpl> subscriptionRepo;
    private final SubscriberProjection projection = new SubscriberProjection(this);

    @Autowired
    public SubscriberRepositoryImpl(SQLQueryFactory queryFactory, Provider<SubscriptionRepositoryImpl> subscriptionRepo) {
        this.queryFactory = queryFactory;
        this.subscriptionRepo = subscriptionRepo;
    }

    @Nullable
    public Subscriber getById(@Nonnull UUID id) {
        return (Subscriber)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIBERS)).where((Predicate)SubscriberRepositoryImpl.SUBSCRIBERS.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIBERS)).where((Predicate)SubscriberRepositoryImpl.SUBSCRIBERS.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public List<Subscriber> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIBERS)).fetch();
    }

    @Nonnull
    public Subscriber create(@Nonnull String name, String host, Integer subscriberType, String signature, String tagList, Integer hostStatus, String notificationURL, Long registrationDate) {
        Timestamp registrationDateTimestamp = new Timestamp(registrationDate);
        UUID uuid = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)SUBSCRIBERS).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.name, (Object)name)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.host, (Object)host)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.subscriberType, (Object)subscriberType)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.signature, (Object)signature)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.tagList, (Object)tagList)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.hostStatus, (Object)hostStatus)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.notificationUrl, (Object)notificationURL)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.registrationDate, (Object)registrationDateTimestamp)).executeWithKey((Path)SubscriberRepositoryImpl.SUBSCRIBERS.id);
        return this.projection.create(uuid, name, host, subscriberType, signature, tagList, hostStatus, notificationURL, registrationDateTimestamp);
    }

    @Nonnull
    public Subscriber update(@Nonnull UUID subscriberId, @Nonnull String name, String host, Integer subscriberType, String signature, String tagList, Integer hostStatus, @Nonnull String notificationURL, Long registrationDate) {
        Timestamp registrationDateTimestamp = new Timestamp(registrationDate);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)SUBSCRIBERS).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.name, (Object)name)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.host, (Object)host)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.subscriberType, (Object)subscriberType)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.signature, (Object)signature)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.tagList, (Object)tagList)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.hostStatus, (Object)hostStatus)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.notificationUrl, (Object)notificationURL)).set((Path)SubscriberRepositoryImpl.SUBSCRIBERS.registrationDate, (Object)registrationDateTimestamp)).where((Predicate)SubscriberRepositoryImpl.SUBSCRIBERS.id.eq((Object)subscriberId))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        return this.projection.create(subscriberId, name, host, subscriberType, signature, tagList, hostStatus, notificationURL, registrationDateTimestamp);
    }

    public void delete(UUID subscriberId) {
        this.deleteReferenceToTable(subscriberId, (RelationalPathBase)SUBSCRIBERS, (SimplePath<UUID>)SubscriberRepositoryImpl.SUBSCRIBERS.id);
    }

    private void deleteReferenceToTable(UUID subscriberId, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)subscriberId))).execute();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class SubscriberProjection
    extends MappingProjection<Subscriber> {
        static final long serialVersionUID = 42L;
        private final transient SubscriberRepositoryImpl repo;

        public SubscriberProjection(SubscriberRepositoryImpl repo) {
            super(Subscriber.class, (Expression[])AbstractRepository.SUBSCRIBERS.all());
            this.repo = repo;
        }

        protected Subscriber map(Tuple tuple) {
            UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.id);
            assert (uuid != null);
            String name = (String)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.name);
            assert (name != null);
            String host = (String)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.host);
            Integer subscriberType = (Integer)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.subscriberType);
            String signature = (String)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.signature);
            String tagList = (String)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.tagList);
            Integer hostStatus = (Integer)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.hostStatus);
            String notificationURL = (String)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.notificationUrl);
            Timestamp registrationDate = (Timestamp)tuple.get((Expression)AbstractRepository.SUBSCRIBERS.registrationDate);
            assert (registrationDate != null);
            return this.create(uuid, name, host, subscriberType, signature, tagList, hostStatus, notificationURL, registrationDate);
        }

        protected SubscriberImpl create(UUID id, String name, String host, Integer subscriberType, String signature, String tagList, Integer hostStatus, String notificationURL, Timestamp registrationDate) {
            List subscriptionsListId = Proxies.list(() -> ((SubscriptionRepositoryImpl)this.repo.subscriptionRepo.get()).getAllByParentId(id));
            return new SubscriberImpl(id, name, host, subscriberType, signature, tagList, hostStatus, notificationURL, Long.valueOf(registrationDate.getTime()), subscriptionsListId);
        }
    }
}

