/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.mapper;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.environments.db.generated.QEnvironments;
import org.qubership.atp.environments.errorhandling.request.EnvironmentsWithFilterRequestException;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.mapper.QueryMapper;
import org.qubership.atp.environments.service.rest.server.request.FilterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentMapper
implements QueryMapper<Environment> {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentMapper.class);
    private final String delimiter = ".";
    public static final String SYSTEMS_FIELD_NAME = "systems";

    @Override
    public BooleanExpression mapFilter(SQLQuery<Environment> sqlQuery, BooleanExpression booleanExpression, List<FilterRequest> filterRequests) {
        for (FilterRequest filterRequest : filterRequests) {
            String tableName;
            if (filterRequest == null || filterRequest.getName() == null || CollectionUtils.isEmpty(filterRequest.getValue())) continue;
            String fieldName = filterRequest.getName();
            QEnvironments table = AbstractRepository.ENVIRONMENTS;
            if (fieldName.contains(".") && (tableName = fieldName.substring(0, fieldName.indexOf("."))).equals(SYSTEMS_FIELD_NAME)) {
                table = AbstractRepository.SYSTEMS;
                fieldName = fieldName.substring(fieldName.indexOf(".") + 1);
                sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)sqlQuery.leftJoin((EntityPath)AbstractRepository.ENVIRONMENT_SYSTEMS)).on((Predicate)AbstractRepository.ENVIRONMENTS.id.eq((Expression)AbstractRepository.ENVIRONMENT_SYSTEMS.environmentId))).leftJoin((EntityPath)AbstractRepository.SYSTEMS)).on((Predicate)AbstractRepository.ENVIRONMENT_SYSTEMS.systemId.eq((Expression)AbstractRepository.SYSTEMS.id));
            }
            Expression<?> fieldValue = this.getField(fieldName, (RelationalPathBase<?>)table);
            if (booleanExpression == null) {
                booleanExpression = this.filterQuery(fieldName, fieldValue, filterRequest.getValue());
                continue;
            }
            booleanExpression = booleanExpression.and((Predicate)this.filterQuery(fieldName, fieldValue, filterRequest.getValue()));
        }
        return booleanExpression;
    }

    public BooleanExpression filterQuery(String fieldName, Expression<?> fieldValue, List<String> filterValue) {
        if (fieldValue instanceof SimplePath && ((SimplePath)fieldValue).getType() == UUID.class) {
            return ((SimplePath)fieldValue).in((Collection)filterValue.stream().map(UUID::fromString).collect(Collectors.toList()));
        }
        if (fieldValue instanceof DateTimePath) {
            return ((DateTimePath)fieldValue).in((Collection)filterValue.stream().map(Timestamp::valueOf).collect(Collectors.toList()));
        }
        if (fieldValue instanceof StringExpression) {
            return ((StringExpression)fieldValue).in(filterValue);
        }
        throw new EnvironmentsWithFilterRequestException(String.format("Incorrect field name: %s", fieldName));
    }

    public Expression<?> getField(String fieldName, RelationalPathBase<?> table) {
        try {
            Field field = table.getClass().getField(fieldName);
            return (Expression)field.get(table);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            String message = String.format("Incorrect field name: %s", fieldName);
            log.error(message, (Throwable)exception);
            throw new EnvironmentsWithFilterRequestException(message);
        }
    }
}

