/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.projections;

import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.environments.db.Proxies;
import org.qubership.atp.environments.model.Project;
import org.qubership.atp.environments.model.impl.EnvironmentImpl;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ProjectRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.repo.projections.ShortEnvironmentProjection;

public class LazyEnvironmentProjection
extends ShortEnvironmentProjection {
    private static final long serialVersionUID = 42L;

    public LazyEnvironmentProjection(EnvironmentRepositoryImpl repo) {
        super(repo);
    }

    @Override
    public EnvironmentImpl create(UUID uuid, String name, String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, Timestamp created, UUID createdBy, Timestamp modified, UUID modifiedBy, @Nonnull UUID projectId, @Nonnull UUID categoryId, UUID sourceId, List<String> tags) {
        UUID projId = Proxies.withId(Project.class, projectId, id -> ((ProjectRepositoryImpl)this.repo.getProjectRepo().get()).getShortById((UUID)id)).getId();
        List systemsListId = Proxies.list(() -> ((SystemRepositoryImpl)this.repo.getSystemRepo().get()).getAllShortByParentId(uuid));
        return new EnvironmentImpl(uuid, name, graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, Long.valueOf(created.getTime()), createdBy, modified == null ? null : Long.valueOf(modified.getTime()), modifiedBy, projId, systemsListId, categoryId, sourceId, tags);
    }
}

