/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.projections;

import com.google.gson.Gson;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.environments.db.Proxies;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.ParametersGettingVersion;
import org.qubership.atp.environments.model.ServerItf;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.impl.SystemImpl;
import org.qubership.atp.environments.model.utils.enums.Status;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.SystemCategoryRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;

public class ShortSystemProjection
extends MappingProjection<System> {
    private static final long serialVersionUID = 42L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    protected final transient SystemRepositoryImpl repo;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    protected transient Gson gson = new Gson();

    public ShortSystemProjection(SystemRepositoryImpl repo) {
        super(System.class, (Expression[])AbstractRepository.SYSTEMS.all());
        this.repo = repo;
    }

    protected System map(Tuple tuple) {
        UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.id);
        assert (uuid != null);
        String name = (String)tuple.get((Expression)AbstractRepository.SYSTEMS.name);
        assert (name != null);
        String description = (String)tuple.get((Expression)AbstractRepository.SYSTEMS.description);
        Timestamp created = (Timestamp)tuple.get((Expression)AbstractRepository.SYSTEMS.created);
        UUID createdBy = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.createdBy);
        Timestamp modified = (Timestamp)tuple.get((Expression)AbstractRepository.SYSTEMS.modified);
        UUID modifiedBy = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.modifiedBy);
        UUID systemCategoryId = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.categoryId);
        String systemStatus = (String)tuple.get((Expression)AbstractRepository.SYSTEMS.status);
        Timestamp dateOfLastCheck = (Timestamp)tuple.get((Expression)AbstractRepository.SYSTEMS.dateOfLastCheck);
        String version = (String)tuple.get((Expression)AbstractRepository.SYSTEMS.version);
        Timestamp dateOfCheckVersion = (Timestamp)tuple.get((Expression)AbstractRepository.SYSTEMS.dateOfCheckVersion);
        String parametersGettingVersion = (String)tuple.get((Expression)AbstractRepository.SYSTEMS.parametersGettingVersion);
        UUID parentSystemId = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.parentSystemId);
        String serverItf = (String)tuple.get((Expression)AbstractRepository.SYSTEMS.serverItf);
        Boolean mergeByName = (Boolean)tuple.get((Expression)AbstractRepository.SYSTEMS.mergeByName);
        UUID linkToSystemId = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.linkToSystemId);
        UUID externalId = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.externalId);
        UUID sourceId = (UUID)tuple.get((Expression)AbstractRepository.SYSTEMS.sourceId);
        String externalName = (String)tuple.get((Expression)AbstractRepository.SYSTEMS.externalName);
        return this.create(uuid, name, description, created, createdBy, modified, modifiedBy, systemCategoryId, systemStatus, dateOfLastCheck, version, dateOfCheckVersion, parametersGettingVersion, parentSystemId, serverItf, mergeByName, linkToSystemId, externalId, sourceId, externalName, null);
    }

    public SystemImpl create(UUID uuid, String name, String description, Timestamp created, UUID createdBy, Timestamp modified, UUID modifiedBy, @Nullable UUID systemCategoryId, String status, Timestamp dateOfLastCheck, String version, Timestamp dateOfCheckVersion, String parametersGettingVersion, @Nullable UUID parentSystemId, String serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, UUID sourceId, String externalName, List<Environment> environments) {
        SystemCategory systemCategory = null;
        if (systemCategoryId != null) {
            systemCategory = Proxies.withId(SystemCategory.class, systemCategoryId, id -> ((SystemCategoryRepositoryImpl)this.repo.getSystemCategoryRepo().get()).getById((UUID)id));
        }
        return this.create(uuid, name, description, created, createdBy, modified, modifiedBy, systemCategory, status, dateOfLastCheck, version, dateOfCheckVersion, parametersGettingVersion, parentSystemId, environments, serverItf, mergeByName, linkToSystemId, externalId, sourceId, externalName);
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public SystemImpl create(UUID uuid, String name, String description, Timestamp created, UUID createdBy, Timestamp modified, UUID modifiedBy, @Nullable SystemCategory systemCategory, @Nullable String status, Timestamp dateOfLastCheck, String version, Timestamp dateOfCheckVersion, String parametersGettingVersion, @Nullable UUID parentSystemId, @Nullable List<Environment> environments, String serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, UUID sourceId, String externalName) {
        return new SystemImpl(uuid, name, description, Long.valueOf(created.getTime()), createdBy, modified == null ? null : Long.valueOf(modified.getTime()), modifiedBy, environments, systemCategory, null, status == null ? Status.NOTHING : Status.valueOf((String)status), dateOfLastCheck == null ? null : Long.valueOf(dateOfLastCheck.getTime()), version, dateOfCheckVersion == null ? null : Long.valueOf(dateOfCheckVersion.getTime()), (ParametersGettingVersion)this.gson.fromJson(parametersGettingVersion, ParametersGettingVersion.class), parentSystemId, (ServerItf)this.gson.fromJson(serverItf, ServerItf.class), mergeByName, linkToSystemId, externalId, sourceId, externalName);
    }
}

