/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.impl.ConnectionImpl;
import org.qubership.atp.environments.service.direct.DecryptorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="decryptorService")
public class DecryptorServiceImpl
implements DecryptorService {
    private static final Logger log = LoggerFactory.getLogger(DecryptorServiceImpl.class);
    protected Decryptor decryptor;

    @Autowired
    public DecryptorServiceImpl(@Nonnull Decryptor decryptor) {
        this.decryptor = decryptor;
    }

    @Override
    public ConnectionParameters decryptParameters(ConnectionParameters parameters) {
        ConnectionParameters result = new ConnectionParameters();
        parameters.forEach((key, value) -> {
            String parameter = this.decryptParameter((String)value);
            result.put(key, (Object)parameter);
        });
        return result;
    }

    @Override
    public String decryptParameter(String sourceParameter) {
        String decryptedValue = sourceParameter;
        try {
            decryptedValue = this.decryptor.decryptIfEncrypted(sourceParameter);
        }
        catch (AtpDecryptException e) {
            log.error("Unable to decrypt: ", (Throwable)e);
        }
        return decryptedValue;
    }

    @Override
    public Connection decryptConnection(Connection connection) {
        ConnectionParameters parameters = this.decryptParameters(connection.getParameters());
        return new ConnectionImpl(connection.getId(), connection.getName(), connection.getDescription(), parameters, connection.getCreated(), connection.getCreatedBy(), connection.getModified(), connection.getModifiedBy(), connection.getSystemId(), connection.getConnectionType(), Objects.requireNonNull(connection.getSourceTemplateId()), connection.getServices(), connection.getSourceId());
    }
}

