/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.Project;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.impl.Context;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ProjectRepositoryImpl;
import org.qubership.atp.environments.service.direct.ConnectionService;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.ProjectAccessService;
import org.qubership.atp.environments.service.direct.ProjectService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.rest.server.dto.CreateSystemDto;
import org.qubership.atp.environments.service.rest.server.dto.EnvironmentDto;
import org.qubership.atp.environments.service.rest.server.request.ProjectSearchRequest;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="projectService")
@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public class ProjectServiceImpl
implements ProjectService {
    private static final Logger log = LoggerFactory.getLogger(ProjectServiceImpl.class);
    public static final String PROJECTS_CACHE_NAME = "projects";
    private final ProjectRepositoryImpl projectRepository;
    private final EnvironmentRepositoryImpl environmentRepository;
    private final EnvironmentService environmentService;
    private final SystemService systemService;
    private final ConnectionService connectionService;
    private final DateTimeUtil dateTimeUtil;
    private final ContextRepository contextRepo;
    private final Provider<UserInfo> userInfoProvider;
    private final PolicyEnforcement policyEnforcement;
    private final ProjectAccessService projectAccessService;

    @Autowired
    public ProjectServiceImpl(ProjectRepositoryImpl projectRepository, EnvironmentRepositoryImpl environmentRepository, EnvironmentService environmentService, SystemService systemService, ConnectionService connectionService, DateTimeUtil dateTimeUtil, ContextRepository contextRepo, Provider<UserInfo> userInfoProvider, PolicyEnforcement policyEnforcement, ProjectAccessService projectAccessService) {
        this.projectRepository = projectRepository;
        this.environmentRepository = environmentRepository;
        this.environmentService = environmentService;
        this.systemService = systemService;
        this.connectionService = connectionService;
        this.dateTimeUtil = dateTimeUtil;
        this.contextRepo = contextRepo;
        this.userInfoProvider = userInfoProvider;
        this.policyEnforcement = policyEnforcement;
        this.projectAccessService = projectAccessService;
    }

    @Override
    @Nullable
    public Project get(@Nonnull UUID id) {
        return this.projectRepository.getById(id);
    }

    @Override
    @Nullable
    public Project getShort(@Nonnull UUID id) {
        return this.projectRepository.getShortById(id);
    }

    @Override
    @Nullable
    public Project getShortByName(String name) {
        return this.projectRepository.getShortByName(name);
    }

    @Override
    public List<Project> getProjectsByRequest(ProjectSearchRequest request) {
        return this.projectRepository.getProjectsByRequest(request, this.projectAccessService.getProjectIdsWithAccess());
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.projectRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<Project> getAll() {
        return this.checkProjectAccess(this.projectRepository.getAll());
    }

    @Override
    @Nonnull
    public List<Project> getAllShort() {
        return this.checkProjectAccess(this.projectRepository.getAllShort());
    }

    @Override
    @Nonnull
    @Transactional
    public Project create(Project project) {
        this.projectRepository.getContext().setFullDbFetching(true);
        return this.projectRepository.create(project.getName(), project.getShortName(), project.getDescription(), this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    @Nonnull
    @Transactional
    public Environment create(UUID projectId, EnvironmentDto environment, UUID categoryId) {
        this.contextRepo.setContext(new Context(true));
        Environment result = this.environmentService.create(projectId, environment.getName(), environment.getGraylogName(), environment.getDescription(), environment.getSsmSolutionAlias(), environment.getSsmInstanceAlias(), environment.getConsulEgressConfigPath(), categoryId, environment.getTags());
        List system = environment.getSystems().stream().map(systemDto -> this.systemService.create(result.getId(), (CreateSystemDto)systemDto)).collect(Collectors.toList());
        result.setSystems(system);
        return result;
    }

    @Override
    @Nonnull
    public Project replicate(@Nonnull UUID projectId, @Nonnull String name, String shortName, String description, Long created) throws AtpException {
        this.projectRepository.getContext().setFullDbFetching(true);
        if (StringUtils.isEmpty((Object)name)) {
            log.error("Found illegal nullable project name parameter");
            throw new AtpIllegalNullableArgumentException("project name", "method argument");
        }
        return this.projectRepository.create(projectId, name, null, description, created);
    }

    @Override
    @Nonnull
    @Transactional
    public Project createAsIs(Project project) {
        this.projectRepository.getContext().setFullDbFetching(true);
        return this.projectRepository.create(project.getId(), project.getName(), project.getShortName(), project.getDescription(), this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    @Nonnull
    @Transactional
    public Project copy(UUID id, String name, String shortName, String description) {
        this.projectRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        Project sourceProject = this.projectRepository.getById(id);
        Preconditions.checkNotNull((Object)sourceProject, (Object)("Project not found by id:" + id));
        Project newProject = this.projectRepository.create(name, shortName, description, this.dateTimeUtil.timestampAsUtc());
        sourceProject.getEnvironments().forEach(environment -> {
            Environment newEnv = this.environmentRepository.create(environment.getName(), environment.getGraylogName(), environment.getDescription(), environment.getSsmSolutionAlias(), environment.getSsmInstanceAlias(), environment.getConsulEgressConfigPath(), this.dateTimeUtil.timestampAsUtc(), userId, newProject.getId(), environment.getCategoryId(), environment.getTags());
            environment.getSystems().forEach(system -> this.environmentService.createSystem(newEnv.getId(), (System)system));
        });
        return newProject;
    }

    @Override
    @Transactional
    public void update(UUID id, String name, String shortName, String description) {
        this.projectRepository.getContext().setFullDbFetching(true);
        this.projectRepository.update(id, name, shortName, description, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    @Nonnull
    @CacheEvict(value={"projects"}, key="#id")
    public void update(UUID id, String name, String shortName) {
        this.projectRepository.getContext().setFullDbFetching(true);
        this.projectRepository.update(id, name, shortName, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    @Transactional
    @CacheEvict(value={"projects"}, key="#projectId")
    public void delete(UUID projectId) {
        this.projectRepository.delete(projectId);
    }

    @Override
    public List<Environment> getEnvironments(UUID projectId) {
        return this.environmentRepository.getAllByParentId(Objects.requireNonNull(this.get(projectId)).getId(), Constants.Environment.Category.ENVIRONMENT);
    }

    @Override
    public List<Environment> getShortEnvironments(UUID projectId) {
        return this.environmentRepository.getAllShortByParentId(Objects.requireNonNull(this.get(projectId)).getId(), Constants.Environment.Category.ENVIRONMENT);
    }

    @Override
    public List<Environment> getTemporaryEnvironments(UUID projectId) {
        return this.environmentRepository.getAllByParentId(Objects.requireNonNull(this.get(projectId)).getId(), Constants.Environment.Category.TEMPORARY_ENVIRONMENT);
    }

    @Override
    public List<Environment> getAllEnvironments(UUID projectId) {
        return this.environmentRepository.getAllByParentId(Objects.requireNonNull(this.get(projectId)).getId(), Constants.Environment.Category.ENVIRONMENT, Constants.Environment.Category.TEMPORARY_ENVIRONMENT);
    }

    @Override
    public List<Environment> getTools(UUID projectId) {
        return this.environmentRepository.getAllByParentId(Objects.requireNonNull(this.get(projectId)).getId(), Constants.Environment.Category.TOOL);
    }

    @Override
    public List<Environment> getShortTools(UUID projectId) {
        return this.environmentRepository.getAllShortByParentId(Objects.requireNonNull(this.get(projectId)).getId(), Constants.Environment.Category.TOOL);
    }

    @Override
    public List<System> getSystemsByProjectId(UUID projectId) {
        return this.systemService.getSystemsByProjectId(projectId);
    }

    @Override
    public List<System> getSystemsByProjectIdAndCategoryName(UUID projectId, String categoryName) {
        return this.systemService.getSystemsByProjectIdAndCategoryName(projectId, categoryName);
    }

    @Override
    public List<Connection> getConnections(UUID projectId) {
        return this.connectionService.getConnectionsByProjectId(projectId);
    }

    @Override
    public List<String> getSystemNames(UUID projectId) {
        return this.environmentRepository.getSystemNamesByProjectId(projectId);
    }

    @Override
    public List<String> getConnectionNames(UUID projectId) {
        return this.environmentRepository.getConnectionNamesByProjectId(projectId);
    }

    @Override
    public List<Project> getProjectsByHost(String host) {
        this.contextRepo.setContext(new Context(true));
        List<Connection> connections = this.connectionService.getConnectionByHost(host);
        List<UUID> sysIds = connections.stream().map(Connection::getSystemId).collect(Collectors.toList());
        ArrayList<System> systems = new ArrayList<System>(this.systemService.getByIds(sysIds));
        ArrayList environments = new ArrayList();
        systems.forEach(system -> environments.addAll(system.getEnvironments()));
        Set environmentsIds = environments.stream().map(Identified::getId).collect(Collectors.toSet());
        Set<UUID> prjIds = environments.stream().map(Environment::getProjectId).collect(Collectors.toSet());
        List<Project> projects = this.projectRepository.getByIds(prjIds);
        projects.forEach(project -> project.setEnvironments(project.getEnvironments().stream().filter(environment -> environmentsIds.contains(environment.getId())).collect(Collectors.toList())));
        return projects;
    }

    @Override
    public Project getProjectWithSpecifiedEnvironments(UUID projectId, List<UUID> environmentIds) {
        Project project = this.projectRepository.getLazyById(projectId);
        if (project != null) {
            project.setEnvironments(this.environmentService.getByIds(environmentIds));
        }
        return project;
    }

    private List<Project> checkProjectAccess(List<Project> projects) {
        return CollectionUtils.isEmpty(projects) ? Collections.emptyList() : projects.stream().filter(project -> this.policyEnforcement.checkAccess(project.getId(), Operation.READ)).collect(Collectors.toList());
    }
}

