/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.environments.enums.MdcField;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ParametersGettingVersion;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.impl.SystemImpl;
import org.qubership.atp.environments.model.utils.View;
import org.qubership.atp.environments.model.utils.enums.Status;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.service.direct.ConcurrentModificationService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.rest.server.dto.CreateSystemDto;
import org.qubership.atp.environments.service.rest.server.dto.SharingRequestDto;
import org.qubership.atp.environments.service.rest.server.dto.SystemDto;
import org.qubership.atp.environments.service.rest.server.request.SynchronizeCloudServicesRequest;
import org.qubership.atp.environments.service.rest.server.response.ShortExternalService;
import org.qubership.atp.environments.utils.cloud.KubeClient;
import org.qubership.atp.environments.utils.cloud.OpenshiftClient;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api"})
@RestController
public class SystemController {
    private final SystemService systemService;
    private final ConcurrentModificationService concurrentModificationService;
    private final ContextRepository contextRepository;

    @Autowired
    public SystemController(SystemService systemService, ConcurrentModificationService concurrentModificationService, ContextRepository contextRepository) {
        this.systemService = systemService;
        this.concurrentModificationService = concurrentModificationService;
        this.contextRepository = contextRepository;
    }

    @GetMapping(value={"/systems"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get all systems")
    public List<System> getAll() {
        return this.systemService.getAll();
    }

    @GetMapping(value={"/public/v1/systems/{systemId}/version"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="(Public V1 API) Check system version by system id {{#id.toString()}}")
    public ResponseEntity getCachedVersion(@PathVariable(value="systemId") UUID id) {
        return Optional.ofNullable(this.systemService.getCachedVersionById(id)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/systems/{systemId}"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get system with id {{#id.toString()}}")
    public ResponseEntity<System> getSystem(@PathVariable(value="systemId") UUID id) {
        return Optional.ofNullable((System)this.systemService.get(id)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/systems/short/{systemId}"})
    @JsonView(value={View.FullVer1.class})
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#id),'READ')")
    public ResponseEntity<System> getShortSystem(@PathVariable(value="systemId") UUID id) {
        return Optional.ofNullable(this.systemService.getShortSystem(id)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/systems/byName/{environmentId}/{name}"})
    @JsonView(value={View.FullVer1.class})
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    public ResponseEntity<System> getSystemByName(@PathVariable(value="environmentId") UUID environmentId, @PathVariable(value="name") String name) {
        return Optional.ofNullable(this.systemService.getSystemByNameAndEnvironmentId(name, environmentId)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/v2/systems/{systemId}"})
    @JsonView(value={View.FullVer2.class})
    @AuditAction(auditAction="(V2) Get system by system id {{#id.toString()}}")
    public ResponseEntity<System> getSystemV2(@PathVariable(value="systemId") UUID id) {
        this.contextRepository.getContext().setFieldsToUnfold(new String[]{"environments", "connections", "systemCategory"});
        return Optional.ofNullable(this.systemService.getV2(id)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/systems/{systemId}/connections"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get system connections by system id {{#id.toString()}}")
    public List<Connection> getSystemConnections(@PathVariable(value="systemId") UUID uuid) {
        return this.systemService.getConnections(uuid);
    }

    @Operation(description="Endpoint for getting list of systems on all projects ")
    @GetMapping(value={"/systems/short"})
    @JsonView(value={View.Environments.class})
    @AuditAction(auditAction="Get all short systems with environments id")
    public List<System> getAllSystems() {
        return this.systemService.getAll();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#system.getEnvironmentId()),'CREATE')")
    @PostMapping(value={"/systems"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Create system with name {{#system.name}} in environment id  {{#system.environmentId.toString()}}")
    public System createSystem(@RequestBody CreateSystemDto system) {
        Preconditions.checkNotNull((Object)system.getName(), (Object)"System name can't be null");
        Preconditions.checkArgument((!system.getName().isEmpty() ? 1 : 0) != 0, (Object)"System name can't be empty");
        Preconditions.checkNotNull((Object)system.getEnvironmentId(), (Object)"Environment ID can't be empty");
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.name(), (UUID)system.getEnvironmentId());
        return this.systemService.create(system.getEnvironmentId(), system.getName(), system.getDescription(), system.getSystemCategoryId(), system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#system.getEnvironmentId()),'CREATE')")
    @PostMapping(value={"/systems/{systemId}/copy"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Copy system with id {{#id.toString()}}")
    public System copy(@PathVariable(value="systemId") UUID id, @RequestBody CreateSystemDto system) {
        Preconditions.checkNotNull((Object)system.getName(), (Object)"System name can't be null");
        Preconditions.checkArgument((!system.getName().isEmpty() ? 1 : 0) != 0, (Object)"System name can't be empty");
        Preconditions.checkNotNull((Object)system.getEnvironmentId(), (Object)"Environment ID can't be empty");
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.name(), (UUID)system.getEnvironmentId());
        return this.systemService.copy(id, system.getEnvironmentId(), system.getName(), system.getDescription(), system.getSystemCategoryId(), system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#id),'UPDATE')")
    @PutMapping(value={"/systems/{systemId}/share"})
    @JsonView(value={View.FullVer2.class})
    @AuditAction(auditAction="Share system with id {{#id.toString()}}")
    public ResponseEntity<System> share(@PathVariable(value="systemId") UUID id, @RequestBody SharingRequestDto sharingRequestDto, @RequestParam(value="modified", required=false) Long modified) {
        Preconditions.checkNotNull((Object)sharingRequestDto, (Object)"Environment IDs can't be empty");
        this.contextRepository.getContext().setFieldsToUnfold(new String[]{"environments", "systemCategory"});
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(id, modified, this.systemService);
        System system = this.systemService.shareProcessing(id, sharingRequestDto);
        return ResponseEntity.status((HttpStatus)status).body((Object)system);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#system.getEnvironmentId()),'UPDATE')")
    @PutMapping(value={"/systems/openshift"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Update openshift routes {{#system.name}}")
    public List<Connection> openshiftUpdateRoutes(@RequestBody CreateSystemDto system) {
        Preconditions.checkNotNull((Object)system.getEnvironmentId(), (Object)"Environment ID can't be empty");
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.name(), (UUID)system.getEnvironmentId());
        if (system.getId() != null) {
            MdcUtils.put((String)MdcField.SYSTEM_ID.name(), (UUID)system.getId());
            return this.systemService.updateOpenshiftRoute(system.getId(), system.getEnvironmentId());
        }
        return this.systemService.updateOpenshiftRoute(system.getEnvironmentId());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#systemDto.getId()),'UPDATE')")
    @PutMapping(value={"/systems"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Update system {{#systemDto.getName()}} with system id: {{#systemDto.id.toString()}}")
    public ResponseEntity<System> updateSystem(@RequestBody SystemDto systemDto) {
        Preconditions.checkNotNull((Object)systemDto.getId(), (Object)"System id can't be empty");
        Preconditions.checkNotNull((Object)systemDto.getName(), (Object)"System name can't be null");
        Preconditions.checkArgument((!systemDto.getName().isEmpty() ? 1 : 0) != 0, (Object)"System name can't be empty");
        this.contextRepository.getContext().setFieldsToUnfold(new String[]{"connections"});
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(systemDto.getId(), systemDto.getModified(), this.systemService);
        System updatedSystem = this.systemService.update(systemDto);
        return ResponseEntity.status((HttpStatus)status).body((Object)updatedSystem);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'DELETE')")
    @DeleteMapping(value={"/systems/{systemId}"})
    @JsonView(value={View.FullVer1.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete system with id  {{#id.toString()}}")
    public void deleteSystem(@PathVariable(value="systemId") UUID id, @RequestParam(value="environmentId") UUID environmentId) {
        Preconditions.checkNotNull((Object)id, (Object)"system ID can't be empty");
        Preconditions.checkNotNull((Object)environmentId, (Object)"Environment ID can't be empty");
        this.systemService.delete(id, environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'DELETE')")
    @DeleteMapping(value={"/systems/link/{systemId}/{environmentId}"})
    @JsonView(value={View.FullVer1.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete linked systems with parent system id {{#systemId.toString()}}")
    public void deleteLinkedSystems(@PathVariable(value="systemId") UUID systemId, @PathVariable(value="environmentId") UUID environmentId) {
        Preconditions.checkNotNull((Object)systemId, (Object)"system ID can't be empty");
        Preconditions.checkNotNull((Object)environmentId, (Object)"Environment ID can't be empty");
        this.systemService.deleteLinkedServices(systemId, environmentId);
    }

    public System saveStatusAndDateOfLastCheck(UUID id, Status status) {
        return this.systemService.saveStatusAndDateOfLastCheck(id, status);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#id),'UPDATE')")
    @GetMapping(value={"/systems/{systemId}/version"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Check system version by system id {{#systemId.toString()}}")
    public ResponseEntity<System> updateVersion(@PathVariable(value="systemId") UUID id) {
        return Optional.ofNullable(this.systemService.updateVersionBySystemId(id, true)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#id),'UPDATE')")
    @RequestMapping(value={"/systems/{systemId}/htmlVersion"}, method={RequestMethod.GET}, produces={"text/plain"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Check system version and convert to html by system id {{#systemId.toString()}}")
    public ResponseEntity<String> getHtmlVersion(@PathVariable(value="systemId") UUID id) {
        return Optional.ofNullable(this.systemService.transformSystemVersionToHtml(this.systemService.updateVersionBySystemId(id, true)).getVersion()).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @RequestMapping(value={"/public/v1/systems/{systemId}/htmlVersion"}, method={RequestMethod.GET}, produces={"text/plain"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="(Public V1 API) Check system version and convert to html by system id {{#systemId.toString()}}")
    public ResponseEntity<String> getPublicHtmlVersion(@PathVariable(value="systemId") UUID systemId) {
        return Optional.ofNullable(this.systemService.transformSystemVersionToHtml((System)((SystemImpl)this.systemService.getCachedVersionById(systemId))).getVersion()).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#systemId),'UPDATE')")
    @PutMapping(value={"/systems/{systemId}/parametersGettingVersion"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Update parameters getting version for system Id {{#systemId.toString()}}")
    public System updateParametersGettingVersion(@PathVariable(value="systemId") UUID systemId, @RequestBody ParametersGettingVersion parametersGettingVersion) {
        return this.systemService.updateParametersGettingVersion(systemId, parametersGettingVersion);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'CREATE')")
    @PostMapping(value={"/systems/kubeServices/{environmentId}/{systemId}"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Synchronize services from kubernetes by system id {{#systemId.toString()}}")
    public List<System> synchronizeServicesFromKubernetes(@PathVariable(value="systemId") UUID systemId, @PathVariable(value="environmentId") UUID environmentId, @RequestBody SynchronizeCloudServicesRequest request) {
        this.systemService.deleteSystemsByIds(request.getRemovedServicesSystemIds(), environmentId);
        return this.systemService.createListFromCloudServer(request.getNewServicesExternalIds(), systemId, environmentId, KubeClient.class);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#systemId),'UPDATE')")
    @GetMapping(value={"/systems/kubeServices/{systemId}"})
    @JsonView(value={View.FullVer2.class})
    @AuditAction(auditAction="Update services from kubernetes by system id {{#systemId.toString()}}")
    public List<System> updateServicesFromKubernetes(@PathVariable(value="systemId") UUID systemId) {
        return this.systemService.updateServicesFromCloudServer(systemId, KubeClient.class);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'CREATE')")
    @PostMapping(value={"/systems/openshiftServices/{environmentId}/{systemId}"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Synchronize services from openshift by system id {{#systemId.toString()}} and {{#environmentId.toString()}}")
    public List<System> synchronizeServicesFromOpenShift(@PathVariable(value="systemId") UUID systemId, @PathVariable(value="environmentId") UUID environmentId, @RequestBody SynchronizeCloudServicesRequest request) {
        this.systemService.deleteSystemsByIds(request.getRemovedServicesSystemIds(), environmentId);
        return this.systemService.createListFromCloudServer(request.getNewServicesExternalIds(), systemId, environmentId, OpenshiftClient.class);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdBySystemId(#systemId),'UPDATE')")
    @GetMapping(value={"/systems/openshiftServices/{systemId}"})
    @JsonView(value={View.FullVer2.class})
    @AuditAction(auditAction="Update services from openshift by system id {{#systemId.toString()}}")
    public List<System> updateServicesFromOpenshift(@PathVariable(value="systemId") UUID systemId) {
        return this.systemService.updateServicesFromCloudServer(systemId, OpenshiftClient.class);
    }

    @GetMapping(value={"/systems/shortKubeServices/{systemId}"})
    @AuditAction(auditAction="Get kubernetes service names by system id {{#systemId.toString()}}")
    public List<ShortExternalService> getKubernetesServiceNames(@PathVariable(value="systemId") UUID systemId) {
        return this.systemService.getShortExternalServices(systemId, KubeClient.class);
    }

    @GetMapping(value={"/systems/shortOpenshiftServices/{systemId}"})
    @AuditAction(auditAction="Get openshift service names by system id {{#systemId.toString()}}")
    public List<ShortExternalService> getOpenshiftServiceNames(@PathVariable(value="systemId") UUID systemId) {
        return this.systemService.getShortExternalServices(systemId, OpenshiftClient.class);
    }

    @GetMapping(value={"/systems/link/{systemId}"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get linked cloud services  by system id {{#systemId.toString()}}")
    public List<System> getLinkedCloudServices(@PathVariable(value="systemId") UUID systemId) {
        return this.systemService.getLinkedSystemByParentId(systemId);
    }
}

