/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.dto.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemTypeDtoGenerated;
import org.springframework.format.annotation.DateTimeFormat;

@JsonTypeName(value="HistoryItem")
public class HistoryItemDtoGenerated {
    @JsonProperty(value="type")
    private HistoryItemTypeDtoGenerated type;
    @JsonProperty(value="version")
    private Integer version;
    @JsonProperty(value="modifiedWhen")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime modifiedWhen;
    @JsonProperty(value="modifiedBy")
    private String modifiedBy;
    @JsonProperty(value="added")
    @Valid
    private List<String> added = null;
    @JsonProperty(value="deleted")
    @Valid
    private List<String> deleted = null;
    @JsonProperty(value="changed")
    @Valid
    private List<String> changed = null;

    public HistoryItemDtoGenerated type(HistoryItemTypeDtoGenerated type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", required=false)
    public HistoryItemTypeDtoGenerated getType() {
        return this.type;
    }

    public void setType(HistoryItemTypeDtoGenerated type) {
        this.type = type;
    }

    public HistoryItemDtoGenerated version(Integer version) {
        this.version = version;
        return this;
    }

    @Min(value=1L)
    @Schema(name="version", description="commit nubmer of current changes", required=false)
    public @Min(value=1L) Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public HistoryItemDtoGenerated modifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
        return this;
    }

    @Valid
    @Schema(name="modifiedWhen", example="2020-04-15T12:34:56.789Z", required=false)
    public OffsetDateTime getModifiedWhen() {
        return this.modifiedWhen;
    }

    public void setModifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public HistoryItemDtoGenerated modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @Schema(name="modifiedBy", example="Administrator", required=false)
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public HistoryItemDtoGenerated added(List<String> added) {
        this.added = added;
        return this;
    }

    public HistoryItemDtoGenerated addAddedItem(String addedItem) {
        if (this.added == null) {
            this.added = new ArrayList<String>();
        }
        this.added.add(addedItem);
        return this;
    }

    @Schema(name="added", required=false)
    public List<String> getAdded() {
        return this.added;
    }

    public void setAdded(List<String> added) {
        this.added = added;
    }

    public HistoryItemDtoGenerated deleted(List<String> deleted) {
        this.deleted = deleted;
        return this;
    }

    public HistoryItemDtoGenerated addDeletedItem(String deletedItem) {
        if (this.deleted == null) {
            this.deleted = new ArrayList<String>();
        }
        this.deleted.add(deletedItem);
        return this;
    }

    @Schema(name="deleted", required=false)
    public List<String> getDeleted() {
        return this.deleted;
    }

    public void setDeleted(List<String> deleted) {
        this.deleted = deleted;
    }

    public HistoryItemDtoGenerated changed(List<String> changed) {
        this.changed = changed;
        return this;
    }

    public HistoryItemDtoGenerated addChangedItem(String changedItem) {
        if (this.changed == null) {
            this.changed = new ArrayList<String>();
        }
        this.changed.add(changedItem);
        return this;
    }

    @Schema(name="changed", required=false)
    public List<String> getChanged() {
        return this.changed;
    }

    public void setChanged(List<String> changed) {
        this.changed = changed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryItemDtoGenerated historyItem = (HistoryItemDtoGenerated)o;
        return Objects.equals((Object)this.type, (Object)historyItem.type) && Objects.equals(this.version, historyItem.version) && Objects.equals(this.modifiedWhen, historyItem.modifiedWhen) && Objects.equals(this.modifiedBy, historyItem.modifiedBy) && Objects.equals(this.added, historyItem.added) && Objects.equals(this.deleted, historyItem.deleted) && Objects.equals(this.changed, historyItem.changed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.version, this.modifiedWhen, this.modifiedBy, this.added, this.deleted, this.changed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryItemDtoGenerated {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    modifiedWhen: ").append(this.toIndentedString(this.modifiedWhen)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    added: ").append(this.toIndentedString(this.added)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    changed: ").append(this.toIndentedString(this.changed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

