/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemCategoryDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemCategoryImplDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemCategoryNameViewDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="SystemCategoryController", description="System Category Controller")
public interface SystemCategoryControllerApi {
    @Operation(operationId="createSystemCategory", summary="create", tags={"system-category-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemCategoryDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/system-categories"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemCategoryDtoGenerated> createSystemCategory(@Parameter(name="SystemCategoryImplDtoGenerated", description="") @Valid @RequestBody(required=false) SystemCategoryImplDtoGenerated var1);

    @Operation(operationId="deleteCategory", summary="delete", tags={"system-category-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/system-categories/{systemCategoryId}"})
    public ResponseEntity<Void> deleteCategory(@Parameter(name="systemCategoryId", description="systemCategoryId", required=true) @PathVariable(value="systemCategoryId") UUID var1);

    @Operation(operationId="getAllSystemCategories", summary="getAll", tags={"system-category-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemCategoryDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/system-categories"}, produces={"application/json"})
    public ResponseEntity<List<SystemCategoryDtoGenerated>> getAllSystemCategories();

    @Operation(operationId="getShortAll", summary="Getting system categories in abbreviated form :{id:\"\",name:\"\"}", tags={"system-category-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemCategoryNameViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/system-categories/short"}, produces={"application/json"})
    public ResponseEntity<List<SystemCategoryNameViewDtoGenerated>> getShortAll();

    @Operation(operationId="getSystemCategory", summary="get", tags={"system-category-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemCategoryDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/system-categories/{systemCategoryId}"}, produces={"application/json"})
    public ResponseEntity<SystemCategoryDtoGenerated> getSystemCategory(@Parameter(name="systemCategoryId", description="systemCategoryId", required=true) @PathVariable(value="systemCategoryId") UUID var1);

    @Operation(operationId="updateSystemCategory", summary="update", tags={"system-category-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemCategoryDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/system-categories"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemCategoryDtoGenerated> updateSystemCategory(@Parameter(name="SystemCategoryImplDtoGenerated", description="") @Valid @RequestBody(required=false) SystemCategoryImplDtoGenerated var1);
}

