/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.websocket;

import java.util.Arrays;
import org.qubership.atp.environments.service.websocket.WebSocketEventType;
import org.qubership.atp.integration.configuration.interceptors.MdcChannelInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    private static final String WS_API = "/ws/api";
    private final MdcChannelInterceptor mdcChannelInterceptor;
    @Value(value="${ws.inbound.channel.thread.pool.core-pool-size}")
    private Integer wsInboundCorePoolSize;
    @Value(value="${ws.inbound.channel.thread.pool.max-pool-size}")
    private Integer wsInboundMaxPoolSize;
    @Value(value="${ws.inbound.channel.thread.pool.queue-capacity}")
    private Integer wsInboundQueueCapacity;

    public void configureMessageBroker(MessageBrokerRegistry config) {
        Arrays.stream(WebSocketEventType.values()).forEach(eventType -> config.enableSimpleBroker(new String[]{eventType.getDestinationPrefix()}));
        config.setApplicationDestinationPrefixes(new String[]{WS_API});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{WS_API}).setAllowedOrigins(new String[]{"*"});
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.wsInboundCorePoolSize.intValue());
        threadPoolTaskExecutor.setMaxPoolSize(this.wsInboundMaxPoolSize.intValue());
        threadPoolTaskExecutor.setQueueCapacity(this.wsInboundQueueCapacity.intValue());
        registration.interceptors(new ChannelInterceptor[]{this.mdcChannelInterceptor});
        registration.taskExecutor(threadPoolTaskExecutor);
    }

    public WebSocketConfig(MdcChannelInterceptor mdcChannelInterceptor) {
        this.mdcChannelInterceptor = mdcChannelInterceptor;
    }
}

