/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.version.checkers;

import com.jayway.jsonpath.PathNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpVersionChecker
implements VersionChecker {
    private static final Logger log = LoggerFactory.getLogger(HttpVersionChecker.class);
    private static final Pattern BUILD_VERSION_PATTERN = Pattern.compile("build_number:\\s*(.*?)\\s*\\n?$", 8);
    private static final Pattern BUILD_VERSION_PORTAL = Pattern.compile("Build number is\\s*(.*?)\\s*\\n?<[^>]*>$", 8);
    private String url;
    private String login;
    private String password;
    private Boolean auth = false;
    private String parameters = "";
    private String jsonHeaders = "";
    private final CloseableHttpClient httpClient;

    @Override
    public void setConnectionParameters(Connection parameters) {
        this.url = (String)parameters.getParameters().get((Object)"url");
        this.login = (String)parameters.getParameters().get((Object)"login");
        this.password = (String)parameters.getParameters().get((Object)"password");
    }

    @Override
    public void setParametersVersionCheck(String parameters) {
        this.parameters = parameters;
    }

    public void setJsonHeaders(String jsonHeaders) {
        this.jsonHeaders = jsonHeaders;
    }

    public void setAuthorization() {
        this.auth = true;
    }

    @Override
    public String getVersion() {
        ArrayList<String> version = new ArrayList<String>();
        try {
            CloseableHttpResponse response;
            HttpEntity entity;
            String content;
            HttpGet httpRequest = new HttpGet(((String)Validate.notNull((Object)this.url)).concat(this.parameters));
            httpRequest.addHeader("Content-Type", "application/json");
            if (this.auth.booleanValue()) {
                if (!StringUtils.isEmpty((CharSequence)this.jsonHeaders)) {
                    HashMap<String, String> headers = this.parseJsonHeaders();
                    if (!headers.containsKey("Authorization".toLowerCase(Locale.ENGLISH))) {
                        this.setAuthHeaders(httpRequest);
                    }
                    if (!headers.containsKey("x-client-application-name")) {
                        httpRequest.addHeader("x-client-application-name", "NCECARE");
                    }
                    for (Map.Entry<String, String> header : headers.entrySet()) {
                        httpRequest.addHeader(header.getKey(), header.getValue());
                    }
                } else {
                    this.setAuthHeaders(httpRequest);
                    httpRequest.addHeader("x-client-application-name", "NCECARE");
                }
            }
            if (!(content = EntityUtils.toString((HttpEntity)(entity = (response = this.httpClient.execute((HttpUriRequest)httpRequest)).getEntity()))).contains("<!DOCTYPE html")) {
                if ("/version_history.txt".equals(this.parameters) || "/version.txt".equals(this.parameters)) {
                    version.addAll(this.parseVersions(content, BUILD_VERSION_PATTERN));
                } else if (this.parameters.matches(".*portal-info.jsp")) {
                    version.addAll(this.parseVersions(content, BUILD_VERSION_PORTAL));
                } else {
                    version.add(content);
                }
            }
            return !version.isEmpty() ? (String)version.get(0) : "Unknown";
        }
        catch (PathNotFoundException | IOException | ParseException e) {
            log.error(e.getMessage());
            return !version.isEmpty() ? ((Object)version).toString() : "Unknown";
        }
    }

    private List<String> parseVersions(String versionBody, Pattern pattern) {
        ArrayList<String> versions = new ArrayList<String>();
        if (versionBody.toLowerCase(Locale.ENGLISH).contains("html")) {
            versions.add(versionBody);
        }
        Matcher matcher = pattern.matcher(versionBody);
        while (matcher.find()) {
            versions.add(matcher.group(1));
        }
        Collections.reverse(versions);
        return versions;
    }

    private void setAuthHeaders(HttpGet httpRequest) {
        String auth = this.login + ":" + this.password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + new String(encodedAuth, StandardCharsets.UTF_8);
        httpRequest.setHeader("Authorization", authHeader);
    }

    private HashMap<String, String> parseJsonHeaders() throws ParseException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)this.jsonHeaders)) {
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(this.jsonHeaders);
            JSONArray headersArray = (JSONArray)jsonObject.get((Object)"headers");
            for (Object header : headersArray) {
                JSONObject jsonHeader = (JSONObject)header;
                String name = ((String)jsonHeader.get((Object)"name")).toLowerCase(Locale.ENGLISH);
                String body = (String)jsonHeader.get((Object)"body");
                headers.put(name, body);
            }
        }
        return headers;
    }

    public HttpVersionChecker(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

