/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.model.entities;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.javers.core.metamodel.annotation.TypeName;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.service.direct.EnvironmentCategoryService;
import org.qubership.atp.environments.service.direct.ProjectService;
import org.qubership.atp.environments.versioning.model.entities.AbstractJaversEntity;
import org.qubership.atp.environments.versioning.validation.ReferenceExists;

@TypeName(value="Environment")
public class EnvironmentJ
extends AbstractJaversEntity {
    private String name;
    private String description;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    private Date modified;
    @ReferenceExists(service=ProjectService.class, message="project")
    private UUID projectId;
    @ReferenceExists(service=EnvironmentCategoryService.class, message="environment category")
    private UUID categoryId;
    private Set<UUID> systemIds;
    private List<String> tags;

    public EnvironmentJ(Environment model) {
        super((Identified)model);
        this.name = model.getName();
        this.description = model.getDescription();
        this.modified = model.getModified() == null ? null : new Date(model.getModified());
        this.projectId = model.getProjectId();
        this.categoryId = model.getCategoryId();
        this.tags = model.getTags();
        if (!CollectionUtils.isEmpty((Collection)model.getSystems())) {
            this.systemIds = model.getSystems().stream().map(Identified::getId).collect(Collectors.toSet());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getModified() {
        return this.modified;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public UUID getCategoryId() {
        return this.categoryId;
    }

    public Set<UUID> getSystemIds() {
        return this.systemIds;
    }

    public List<String> getTags() {
        return this.tags;
    }
}

