/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.org.apache.calcite.avatica.util.DateTimeUtils;
import com.hazelcast.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.org.apache.calcite.avatica.util.TimeUnitRange;
import com.hazelcast.org.apache.calcite.rel.metadata.NullSentinel;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.org.apache.calcite.rex.RexFieldAccess;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexOver;
import com.hazelcast.org.apache.calcite.rex.RexPatternFieldRef;
import com.hazelcast.org.apache.calcite.rex.RexRangeRef;
import com.hazelcast.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.org.apache.calcite.rex.RexTableInputRef;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.util.NlsString;
import com.hazelcast.org.apache.calcite.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntPredicate;

public class RexInterpreter
implements RexVisitor<Comparable> {
    private static final NullSentinel N = NullSentinel.INSTANCE;
    public static final EnumSet<SqlKind> SUPPORTED_SQL_KIND = EnumSet.of(SqlKind.IS_NOT_DISTINCT_FROM, new SqlKind[]{SqlKind.EQUALS, SqlKind.IS_DISTINCT_FROM, SqlKind.NOT_EQUALS, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN, SqlKind.LESS_THAN_OR_EQUAL, SqlKind.AND, SqlKind.OR, SqlKind.NOT, SqlKind.CASE, SqlKind.IS_TRUE, SqlKind.IS_NOT_TRUE, SqlKind.IS_FALSE, SqlKind.IS_NOT_FALSE, SqlKind.PLUS_PREFIX, SqlKind.MINUS_PREFIX, SqlKind.PLUS, SqlKind.MINUS, SqlKind.TIMES, SqlKind.DIVIDE, SqlKind.COALESCE, SqlKind.CEIL, SqlKind.FLOOR, SqlKind.EXTRACT});
    private final Map<RexNode, Comparable> environment;

    private RexInterpreter(Map<RexNode, Comparable> environment) {
        this.environment = ImmutableMap.copyOf(environment);
    }

    public static Comparable evaluate(RexNode e, Map<RexNode, Comparable> map) {
        Comparable v = e.accept(new RexInterpreter(map));
        return v;
    }

    private IllegalArgumentException unbound(RexNode e) {
        return new IllegalArgumentException("unbound: " + e);
    }

    private Comparable getOrUnbound(RexNode e) {
        Comparable comparable = this.environment.get(e);
        if (comparable != null) {
            return comparable;
        }
        throw this.unbound(e);
    }

    @Override
    public Comparable visitInputRef(RexInputRef inputRef) {
        return this.getOrUnbound(inputRef);
    }

    @Override
    public Comparable visitLocalRef(RexLocalRef localRef) {
        throw this.unbound(localRef);
    }

    @Override
    public Comparable visitLiteral(RexLiteral literal) {
        return (Comparable)((Object)Util.first(literal.getValue4(), N));
    }

    @Override
    public Comparable visitOver(RexOver over) {
        throw this.unbound(over);
    }

    @Override
    public Comparable visitCorrelVariable(RexCorrelVariable correlVariable) {
        return this.getOrUnbound(correlVariable);
    }

    @Override
    public Comparable visitDynamicParam(RexDynamicParam dynamicParam) {
        return this.getOrUnbound(dynamicParam);
    }

    @Override
    public Comparable visitRangeRef(RexRangeRef rangeRef) {
        throw this.unbound(rangeRef);
    }

    @Override
    public Comparable visitFieldAccess(RexFieldAccess fieldAccess) {
        return this.getOrUnbound(fieldAccess);
    }

    @Override
    public Comparable visitSubQuery(RexSubQuery subQuery) {
        throw this.unbound(subQuery);
    }

    @Override
    public Comparable visitTableInputRef(RexTableInputRef fieldRef) {
        throw this.unbound(fieldRef);
    }

    @Override
    public Comparable visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        throw this.unbound(fieldRef);
    }

    @Override
    public Comparable visitCall(RexCall call) {
        ArrayList<Comparable> values = new ArrayList<Comparable>(call.operands.size());
        for (RexNode operand : call.operands) {
            values.add(operand.accept(this));
        }
        switch (call.getKind()) {
            case IS_NOT_DISTINCT_FROM: {
                if (this.containsNull(values)) {
                    return Boolean.valueOf(((Comparable)values.get(0)).equals(values.get(1)));
                }
            }
            case EQUALS: {
                return this.compare(values, c -> c == 0);
            }
            case IS_DISTINCT_FROM: {
                if (this.containsNull(values)) {
                    return Boolean.valueOf(!((Comparable)values.get(0)).equals(values.get(1)));
                }
            }
            case NOT_EQUALS: {
                return this.compare(values, c -> c != 0);
            }
            case GREATER_THAN: {
                return this.compare(values, c -> c > 0);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.compare(values, c -> c >= 0);
            }
            case LESS_THAN: {
                return this.compare(values, c -> c < 0);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.compare(values, c -> c <= 0);
            }
            case AND: {
                return values.stream().map(Truthy::of).min(Comparator.naturalOrder()).get().toComparable();
            }
            case OR: {
                return values.stream().map(Truthy::of).max(Comparator.naturalOrder()).get().toComparable();
            }
            case NOT: {
                return this.not((Comparable)values.get(0));
            }
            case CASE: {
                return this.case_(values);
            }
            case IS_TRUE: {
                return Boolean.valueOf(((Comparable)values.get(0)).equals(true));
            }
            case IS_NOT_TRUE: {
                return Boolean.valueOf(!((Comparable)values.get(0)).equals(true));
            }
            case IS_NULL: {
                return Boolean.valueOf(((Comparable)values.get(0)).equals((Object)N));
            }
            case IS_NOT_NULL: {
                return Boolean.valueOf(!((Comparable)values.get(0)).equals((Object)N));
            }
            case IS_FALSE: {
                return Boolean.valueOf(((Comparable)values.get(0)).equals(false));
            }
            case IS_NOT_FALSE: {
                return Boolean.valueOf(!((Comparable)values.get(0)).equals(false));
            }
            case PLUS_PREFIX: {
                return (Comparable)values.get(0);
            }
            case MINUS_PREFIX: {
                return this.containsNull(values) ? N : this.number((Comparable)values.get(0)).negate();
            }
            case PLUS: {
                return this.containsNull(values) ? N : this.number((Comparable)values.get(0)).add(this.number((Comparable)values.get(1)));
            }
            case MINUS: {
                return this.containsNull(values) ? N : this.number((Comparable)values.get(0)).subtract(this.number((Comparable)values.get(1)));
            }
            case TIMES: {
                return this.containsNull(values) ? N : this.number((Comparable)values.get(0)).multiply(this.number((Comparable)values.get(1)));
            }
            case DIVIDE: {
                return this.containsNull(values) ? N : this.number((Comparable)values.get(0)).divide(this.number((Comparable)values.get(1)));
            }
            case CAST: {
                return this.cast(call, values);
            }
            case COALESCE: {
                return this.coalesce(call, values);
            }
            case CEIL: 
            case FLOOR: {
                return this.ceil(call, values);
            }
            case EXTRACT: {
                return this.extract(call, values);
            }
        }
        throw this.unbound(call);
    }

    private Comparable extract(RexCall call, List<Comparable> values) {
        Comparable v = values.get(1);
        if (v == N) {
            return N;
        }
        TimeUnitRange timeUnitRange = (TimeUnitRange)((Object)values.get(0));
        int v2 = v instanceof Long ? (int)((Long)v / TimeUnit.DAY.multiplier.longValue()) : (Integer)v;
        return Long.valueOf(DateTimeUtils.unixDateExtract(timeUnitRange, v2));
    }

    private Comparable coalesce(RexCall call, List<Comparable> values) {
        for (Comparable value : values) {
            if (value == N) continue;
            return value;
        }
        return N;
    }

    private Comparable ceil(RexCall call, List<Comparable> values) {
        if (values.get(0) == N) {
            return N;
        }
        Long v = (Long)values.get(0);
        TimeUnitRange unit = (TimeUnitRange)((Object)values.get(1));
        switch (unit) {
            case YEAR: 
            case MONTH: {
                switch (call.getKind()) {
                    case FLOOR: {
                        return Long.valueOf(DateTimeUtils.unixTimestampFloor(unit, v));
                    }
                }
                return Long.valueOf(DateTimeUtils.unixTimestampCeil(unit, v));
            }
        }
        TimeUnitRange subUnit = this.subUnit(unit);
        long v2 = v;
        int e;
        while ((e = DateTimeUtils.unixTimestampExtract(subUnit, v2)) != 0) {
            v2 -= unit.startUnit.multiplier.longValue();
        }
        return Long.valueOf(v2);
    }

    private TimeUnitRange subUnit(TimeUnitRange unit) {
        switch (unit) {
            case QUARTER: {
                return TimeUnitRange.MONTH;
            }
        }
        return TimeUnitRange.DAY;
    }

    private Comparable cast(RexCall call, List<Comparable> values) {
        if (values.get(0) == N) {
            return N;
        }
        return values.get(0);
    }

    private Comparable not(Comparable value) {
        if (value.equals(true)) {
            return Boolean.valueOf(false);
        }
        if (value.equals(false)) {
            return Boolean.valueOf(true);
        }
        return N;
    }

    private Comparable case_(List<Comparable> values) {
        Object elseValue;
        int size;
        if (values.size() % 2 == 0) {
            size = values.size();
            elseValue = N;
        } else {
            size = values.size() - 1;
            elseValue = Util.last(values);
        }
        for (int i = 0; i < size; i += 2) {
            if (!values.get(i).equals(true)) continue;
            return values.get(i + 1);
        }
        return elseValue;
    }

    private BigDecimal number(Comparable comparable) {
        return comparable instanceof BigDecimal ? (BigDecimal)comparable : (comparable instanceof BigInteger ? new BigDecimal((BigInteger)comparable) : (comparable instanceof Long || comparable instanceof Integer || comparable instanceof Short ? new BigDecimal(((Number)((Object)comparable)).longValue()) : new BigDecimal(((Number)((Object)comparable)).doubleValue())));
    }

    private Comparable compare(List<Comparable> values, IntPredicate p) {
        if (this.containsNull(values)) {
            return N;
        }
        Comparable v0 = values.get(0);
        Comparable v1 = values.get(1);
        if (v0 instanceof Number && v1 instanceof NlsString) {
            try {
                v1 = new BigDecimal(((NlsString)v1).getValue());
            }
            catch (NumberFormatException e) {
                return Boolean.valueOf(false);
            }
        }
        if (v1 instanceof Number && v0 instanceof NlsString) {
            try {
                v0 = new BigDecimal(((NlsString)v0).getValue());
            }
            catch (NumberFormatException e) {
                return Boolean.valueOf(false);
            }
        }
        if (v0 instanceof Number) {
            v0 = this.number(v0);
        }
        if (v1 instanceof Number) {
            v1 = this.number(v1);
        }
        int c = v0.compareTo(v1);
        return Boolean.valueOf(p.test(c));
    }

    private boolean containsNull(List<Comparable> values) {
        for (Comparable value : values) {
            if (value != N) continue;
            return true;
        }
        return false;
    }

    static enum Truthy {
        FALSE,
        UNKNOWN,
        TRUE;


        static Truthy of(Comparable c) {
            return c.equals(true) ? TRUE : (c.equals(false) ? FALSE : UNKNOWN);
        }

        Comparable toComparable() {
            switch (this) {
                case TRUE: {
                    return Boolean.valueOf(true);
                }
                case FALSE: {
                    return Boolean.valueOf(false);
                }
                case UNKNOWN: {
                    return N;
                }
            }
            throw new AssertionError();
        }
    }
}

