/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import java.util.Arrays;

public class SqlPosixRegexOperator
extends SqlBinaryOperator {
    private final boolean caseSensitive;
    private final boolean negated;

    SqlPosixRegexOperator(String name, SqlKind kind, boolean caseSensitive, boolean negated) {
        super(name, kind, 32, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME_SAME);
        this.caseSensitive = caseSensitive;
        this.negated = negated;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        pos = pos.plusAll(Arrays.asList(operands));
        operands = Arrays.copyOf(operands, operands.length + 1);
        operands[operands.length - 1] = SqlLiteral.createBoolean(this.caseSensitive, SqlParserPos.ZERO);
        return new SqlBasicCall(this, operands, pos, false, functionQualifier);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType op2Type;
        int operandCount = callBinding.getOperandCount();
        if (operandCount != 2 && operandCount != 3) {
            throw new AssertionError((Object)("Unexpected number of args to " + callBinding.getCall() + ": " + operandCount));
        }
        RelDataType op1Type = callBinding.getOperandType(0);
        if (!SqlTypeUtil.isComparable(op1Type, op2Type = callBinding.getOperandType(1))) {
            throw new AssertionError((Object)("Incompatible first two operand types " + op1Type + " and " + op2Type));
        }
        return SqlTypeUtil.isCharTypeComparable(callBinding, callBinding.operands().subList(0, 2), throwOnFailure);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        if (this.negated) {
            writer.print("!");
        }
        writer.print("~");
        if (!this.caseSensitive) {
            writer.print("*");
        }
        writer.print(" ");
        ((SqlNode)call.operand(1)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.endList(frame);
    }
}

