/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.config.Config;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.LocalTopicStats;
import com.hazelcast.topic.MessageListener;
import com.hazelcast.topic.impl.DataAwareMessage;
import com.hazelcast.topic.impl.TopicEvent;
import com.hazelcast.topic.impl.TopicProxy;
import com.hazelcast.topic.impl.TotalOrderedTopicProxy;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class TopicService
implements ManagedService,
RemoteService,
EventPublishingService,
StatisticsAwareService<LocalTopicStats>,
DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:impl:topicService";
    public static final int ORDERING_LOCKS_LENGTH = 1000;
    private final ConcurrentMap<String, LocalTopicStatsImpl> statsMap = new ConcurrentHashMap<String, LocalTopicStatsImpl>();
    private final Lock[] orderingLocks = new Lock[1000];
    private NodeEngine nodeEngine;
    private final ConstructorFunction<String, LocalTopicStatsImpl> localTopicStatsConstructorFunction = mapName -> new LocalTopicStatsImpl();
    private EventService eventService;
    private final AtomicInteger counter = new AtomicInteger(0);
    private Address localAddress;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        this.localAddress = nodeEngine.getThisAddress();
        for (int i = 0; i < this.orderingLocks.length; ++i) {
            this.orderingLocks[i] = new ReentrantLock();
        }
        this.eventService = nodeEngine.getEventService();
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    public ConcurrentMap<String, LocalTopicStatsImpl> getStatsMap() {
        return this.statsMap;
    }

    @Override
    public void reset() {
        this.statsMap.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public Lock getOrderLock(String key) {
        int index = this.getOrderLockIndex(key);
        return this.orderingLocks[index];
    }

    private int getOrderLockIndex(String key) {
        int hash = key.hashCode();
        return HashUtil.hashToIndex(hash, this.orderingLocks.length);
    }

    @Override
    public ITopic createDistributedObject(String name, UUID source, boolean local) {
        TopicConfig topicConfig = this.nodeEngine.getConfig().findTopicConfig(name);
        if (topicConfig.isGlobalOrderingEnabled()) {
            return new TotalOrderedTopicProxy(name, this.nodeEngine, this);
        }
        return new TopicProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectId, boolean local) {
        this.statsMap.remove(objectId);
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, objectId);
    }

    public void dispatchEvent(Object event, Object listener) {
        TopicEvent topicEvent = (TopicEvent)event;
        ClusterService clusterService = this.nodeEngine.getClusterService();
        MemberImpl member = clusterService.getMember(topicEvent.publisherAddress);
        if (member == null) {
            member = new MemberImpl.Builder(topicEvent.publisherAddress).version(this.nodeEngine.getVersion()).build();
        }
        DataAwareMessage message = new DataAwareMessage(topicEvent.name, topicEvent.data, topicEvent.publishTime, member, this.nodeEngine.getSerializationService());
        this.incrementReceivedMessages(topicEvent.name);
        MessageListener messageListener = (MessageListener)listener;
        messageListener.onMessage(message);
    }

    public LocalTopicStatsImpl getLocalTopicStats(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.statsMap, name, this.statsMap, this.localTopicStatsConstructorFunction);
    }

    public void incrementPublishes(String topicName) {
        this.getLocalTopicStats(topicName).incrementPublishes();
    }

    public void incrementReceivedMessages(String topicName) {
        this.getLocalTopicStats(topicName).incrementReceives();
    }

    public void publishMessage(String topicName, Object payload, boolean multithreaded) {
        Collection<EventRegistration> registrations = this.eventService.getRegistrations(SERVICE_NAME, topicName);
        if (!registrations.isEmpty()) {
            Data payloadData = this.nodeEngine.toData(payload);
            TopicEvent topicEvent = new TopicEvent(topicName, payloadData, this.localAddress);
            int partitionId = multithreaded ? this.counter.incrementAndGet() : topicName.hashCode();
            this.eventService.publishEvent(SERVICE_NAME, registrations, (Object)topicEvent, partitionId);
        }
    }

    public UUID addLocalMessageListener(@Nonnull String name, @Nonnull MessageListener listener) {
        EventRegistration registration = this.eventService.registerLocalListener(SERVICE_NAME, name, listener);
        if (registration == null) {
            return null;
        }
        return registration.getId();
    }

    public UUID addMessageListener(@Nonnull String name, @Nonnull MessageListener listener) {
        return this.eventService.registerListener(SERVICE_NAME, name, listener).getId();
    }

    public Future<UUID> addMessageListenerAsync(@Nonnull String name, @Nonnull MessageListener listener) {
        return this.eventService.registerListenerAsync(SERVICE_NAME, name, listener).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    public boolean removeMessageListener(@Nonnull String name, @Nonnull UUID registrationId) {
        return this.eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    public Future<Boolean> removeMessageListenerAsync(@Nonnull String name, @Nonnull UUID registrationId) {
        return this.eventService.deregisterListenerAsync(SERVICE_NAME, name, registrationId);
    }

    @Override
    public Map<String, LocalTopicStats> getStats() {
        Map<String, LocalTopicStats> topicStats = MapUtil.createHashMap(this.statsMap.size());
        Config config = this.nodeEngine.getConfig();
        for (Map.Entry statEntry : this.statsMap.entrySet()) {
            String name = (String)statEntry.getKey();
            if (!config.getTopicConfig(name).isStatisticsEnabled()) continue;
            topicStats.put(name, (LocalTopicStats)statEntry.getValue());
        }
        return topicStats;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "topic", this.getStats());
    }
}

