/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Locale;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;

public class TextQuery
extends Query {
    private final String DEFAULT_SCORE_FIELD_FIELDNAME = "score";
    private final Document META_TEXT_SCORE = new Document("$meta", (Object)"textScore");
    private String scoreFieldName = "score";
    private boolean includeScore = false;
    private boolean sortByScore = false;
    private int sortByScoreIndex = 0;

    public TextQuery(String wordsAndPhrases) {
        super(TextCriteria.forDefaultLanguage().matching(wordsAndPhrases));
    }

    public TextQuery(String wordsAndPhrases, @Nullable String language) {
        super(TextCriteria.forLanguage(language).matching(wordsAndPhrases));
    }

    public TextQuery(String wordsAndPhrases, @Nullable Locale locale) {
        this(wordsAndPhrases, locale != null ? locale.getLanguage() : (String)null);
    }

    public TextQuery(TextCriteria criteria) {
        super(criteria);
    }

    public static TextQuery queryText(TextCriteria criteria) {
        return new TextQuery(criteria);
    }

    public TextQuery sortByScore() {
        this.sortByScoreIndex = this.getSortObject().size();
        this.includeScore();
        this.sortByScore = true;
        return this;
    }

    public TextQuery includeScore() {
        this.includeScore = true;
        return this;
    }

    public TextQuery includeScore(String fieldname) {
        this.setScoreFieldName(fieldname);
        this.includeScore();
        return this;
    }

    public void setScoreFieldName(String fieldName) {
        this.scoreFieldName = fieldName;
    }

    public String getScoreFieldName() {
        return this.scoreFieldName;
    }

    @Override
    public Document getFieldsObject() {
        if (!this.includeScore) {
            return super.getFieldsObject();
        }
        Document fields = BsonUtils.asMutableDocument((Bson)super.getFieldsObject());
        fields.put(this.getScoreFieldName(), (Object)this.META_TEXT_SCORE);
        return fields;
    }

    @Override
    public Document getSortObject() {
        if (this.sortByScore) {
            int sortByScoreIndex = this.sortByScoreIndex;
            return sortByScoreIndex != 0 ? this.sortByScoreAtPosition(super.getSortObject(), sortByScoreIndex) : this.sortByScoreAtPositionZero();
        }
        return super.getSortObject();
    }

    private Document sortByScoreAtPositionZero() {
        Document sort = new Document();
        sort.put(this.getScoreFieldName(), (Object)this.META_TEXT_SCORE);
        sort.putAll((Map)super.getSortObject());
        return sort;
    }

    private Document sortByScoreAtPosition(Document source, int sortByScoreIndex) {
        Document target = new Document();
        int index = 0;
        for (Map.Entry entry : source.entrySet()) {
            if (index == sortByScoreIndex) {
                target.put(this.getScoreFieldName(), (Object)this.META_TEXT_SCORE);
            }
            target.put((String)entry.getKey(), entry.getValue());
            ++index;
        }
        if (index == sortByScoreIndex) {
            target.put(this.getScoreFieldName(), (Object)this.META_TEXT_SCORE);
        }
        return target;
    }

    @Override
    public boolean isSorted() {
        return super.isSorted() || this.sortByScore;
    }
}

