package org.qubership.atp.environments.clients.api.healthcheck.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.clients.api.healthcheck.dto.EnvironmentStatusDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * MandatoryStatusesResponseDto
 */

@JsonTypeName("MandatoryStatusesResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-05T07:24:46.361723454Z[Etc/UTC]")
public class MandatoryStatusesResponseDto {

  @JsonProperty("reportId")
  private UUID reportId;

  @JsonProperty("statuses")
  @Valid
  private List<EnvironmentStatusDto> statuses = null;

  public MandatoryStatusesResponseDto reportId(UUID reportId) {
    this.reportId = reportId;
    return this;
  }

  /**
   * Get reportId
   * @return reportId
  */
  @Valid 
  @Schema(name = "reportId", required = false)
  public UUID getReportId() {
    return reportId;
  }

  public void setReportId(UUID reportId) {
    this.reportId = reportId;
  }

  public MandatoryStatusesResponseDto statuses(List<EnvironmentStatusDto> statuses) {
    this.statuses = statuses;
    return this;
  }

  public MandatoryStatusesResponseDto addStatusesItem(EnvironmentStatusDto statusesItem) {
    if (this.statuses == null) {
      this.statuses = new ArrayList<>();
    }
    this.statuses.add(statusesItem);
    return this;
  }

  /**
   * Get statuses
   * @return statuses
  */
  @Valid 
  @Schema(name = "statuses", required = false)
  public List<EnvironmentStatusDto> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<EnvironmentStatusDto> statuses) {
    this.statuses = statuses;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MandatoryStatusesResponseDto mandatoryStatusesResponse = (MandatoryStatusesResponseDto) o;
    return Objects.equals(this.reportId, mandatoryStatusesResponse.reportId) &&
        Objects.equals(this.statuses, mandatoryStatusesResponse.statuses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reportId, statuses);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MandatoryStatusesResponseDto {\n");
    sb.append("    reportId: ").append(toIndentedString(reportId)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

