/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.service.rest.server.catalogue.generated;

import org.qubership.atp.environments.clients.api.catalogue.generated.AbstractTestScenarioDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.ActionDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.ActionGroupByTypeCompoundEntryDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.CompoundDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.LabelDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.ProjectDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.ProjectFlagsResponseDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.QaDslLibraryResponseDto;
import java.util.Set;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestCaseDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestCaseGroupDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestPlanDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestScenarioDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestScopeDto;
import java.util.UUID;
import org.qubership.atp.environments.clients.api.catalogue.generated.UserGroupDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.UserInfoDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-05T07:24:46.528358461Z[Etc/UTC]")
@Validated
@Tag(name = "ProjectController", description = "Project Controller")
public interface ProjectControllerApi {

    /**
     * POST /catalog/api/v1/projects/{uuid}/checkFlags : checkFlags
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkFlags",
        summary = "checkFlags",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFlagsResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/projects/{uuid}/checkFlags",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectFlagsResponseDto> checkFlags(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/projects/create : create
     *
     * @param projectDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "create",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/projects/create",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> create(
        @Parameter(name = "ProjectDto", description = "") @Valid @RequestBody(required = false) ProjectDto projectDto
    );


    /**
     * DELETE /catalog/api/v1/projects/{uuid}/users/{usersuuid} : deleteUserFromProject
     *
     * @param uuid uuid (required)
     * @param usersuuid usersuuid (required)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteUserFromProject",
        summary = "deleteUserFromProject",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/catalog/api/v1/projects/{uuid}/users/{usersuuid}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> deleteUserFromProject(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "usersuuid", description = "usersuuid", required = true) @PathVariable("usersuuid") UUID usersuuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/compound : getActionsByProjectId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getActionsByProjectId",
        summary = "getActionsByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ActionDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/compound",
        produces = { "application/json" }
    )
    ResponseEntity<List<ActionDto>> getActionsByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/actions/group-by-type-action : getActionsByProjectUuidGroupedByActionType
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getActionsByProjectUuidGroupedByActionType",
        summary = "getActionsByProjectUuidGroupedByActionType",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ActionGroupByTypeCompoundEntryDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/actions/group-by-type-action",
        produces = { "application/json" }
    )
    ResponseEntity<List<ActionGroupByTypeCompoundEntryDto>> getActionsByProjectUuidGroupedByActionType(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects : getAll
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAll",
        summary = "getAll",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects",
        produces = { "application/json" }
    )
    ResponseEntity<Set<ProjectDto>> getAll(
        
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/compounds/compound_from_ts : getAllCompoundsAndScenarioCompounds
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllCompoundsAndScenarioCompounds",
        summary = "getAllCompoundsAndScenarioCompounds",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = AbstractTestScenarioDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/compounds/compound_from_ts",
        produces = { "application/json" }
    )
    ResponseEntity<List<AbstractTestScenarioDto>> getAllCompoundsAndScenarioCompounds(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/compounds : getAllCompoundsByProject
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllCompoundsByProject",
        summary = "getAllCompoundsByProject",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompoundDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/compounds",
        produces = { "application/json" }
    )
    ResponseEntity<List<CompoundDto>> getAllCompoundsByProject(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/compound_from_ts : getAllCompoundsMadeFromTestScenario
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllCompoundsMadeFromTestScenario",
        summary = "getAllCompoundsMadeFromTestScenario",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestScenarioDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/compound_from_ts",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestScenarioDto>> getAllCompoundsMadeFromTestScenario(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/users/groups : getAllGroups
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllGroups",
        summary = "getAllGroups",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UserGroupDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/users/groups",
        produces = { "application/json" }
    )
    ResponseEntity<List<UserGroupDto>> getAllGroups(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") String uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/qadsllibraries : getAllQaDslLibrariesInProject
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllQaDslLibrariesInProject",
        summary = "getAllQaDslLibrariesInProject",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = QaDslLibraryResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/qadsllibraries",
        produces = { "application/json" }
    )
    ResponseEntity<List<QaDslLibraryResponseDto>> getAllQaDslLibrariesInProject(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/short : getAllShortProjects
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllShortProjects",
        summary = "getAllShortProjects",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectDto>> getAllShortProjects(
        
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/users/enriched : getAllUsersByProject
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllUsersByProject",
        summary = "getAllUsersByProject",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UserInfoDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/users/enriched",
        produces = { "application/json" }
    )
    ResponseEntity<List<UserInfoDto>> getAllUsersByProject(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/itf/url : getItfUrl
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getItfUrl",
        summary = "getItfUrl",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/itf/url",
        produces = { "application/json" }
    )
    ResponseEntity<Set<String>> getItfUrl(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testplans/qa-dsl-not-mapped : getNotMappedTestPlansByProjectId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getNotMappedTestPlansByProjectId",
        summary = "getNotMappedTestPlansByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testplans/qa-dsl-not-mapped",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestPlanDto>> getNotMappedTestPlansByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid} : getProjectById
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectById",
        summary = "getProjectById",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> getProjectById(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/number-of-threshold : getProjectNumberOfThresholdByProjectId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectNumberOfThresholdByProjectId",
        summary = "getProjectNumberOfThresholdByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Integer.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/number-of-threshold",
        produces = { "application/json" }
    )
    ResponseEntity<Integer> getProjectNumberOfThresholdByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testcases/labels : getProjectTestCaseLabels
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectTestCaseLabels",
        summary = "getProjectTestCaseLabels",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testcases/labels",
        produces = { "application/json" }
    )
    ResponseEntity<List<LabelDto>> getProjectTestCaseLabels(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/users : getProjectsUsersById
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectsUsersById",
        summary = "getProjectsUsersById",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/users",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> getProjectsUsersById(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testcases/short : getShortCasesByProjectId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getShortCasesByProjectId",
        summary = "getShortCasesByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testcases/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseDto>> getShortCasesByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testscopes/short : getShortScopesByProjectId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getShortScopesByProjectId",
        summary = "getShortScopesByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestScopeDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testscopes/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestScopeDto>> getShortScopesByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testcasegroups/short : getTestCaseGroupNamesByProjectId
     *
     * @param uuid uuid (required)
     * @param testPlanId testPlanId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCaseGroupNamesByProjectId",
        summary = "getTestCaseGroupNamesByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseGroupDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testcasegroups/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseGroupDto>> getTestCaseGroupNamesByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @NotNull @Parameter(name = "testPlanId", description = "testPlanId", required = true) @Valid @RequestParam(value = "testPlanId", required = true) UUID testPlanId
    );


    /**
     * GET /catalog/api/v1/projects/testcasegroups : getTestCaseGroupsByProjectId
     *
     * @param projectId projectId (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCaseGroupsByProjectId",
        summary = "getTestCaseGroupsByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseGroupDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/testcasegroups",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseGroupDto>> getTestCaseGroupsByProjectId(
        @Parameter(name = "projectId", description = "projectId") @Valid @RequestParam(value = "projectId", required = false) UUID projectId
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testplans : getTestPlansByProjectId
     *
     * @param uuid uuid (required)
     * @param withoutQaDsl without-qa-dsl (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestPlansByProjectId",
        summary = "getTestPlansByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testplans",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestPlanDto>> getTestPlansByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "without-qa-dsl", description = "without-qa-dsl") @Valid @RequestParam(value = "without-qa-dsl", required = false) String withoutQaDsl
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testscenarios : getTestScenariosByProjectId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestScenariosByProjectId",
        summary = "getTestScenariosByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestScenarioDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testscenarios",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestScenarioDto>> getTestScenariosByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/projects/{uuid}/testscopes : getTestScopeByProjectId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestScopeByProjectId",
        summary = "getTestScopeByProjectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestScopeDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/projects/{uuid}/testscopes",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestScopeDto>> getTestScopeByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * PUT /catalog/api/v1/projects/save : update
     *
     * @param projectDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "update",
        summary = "update",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/projects/save",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> update(
        @Parameter(name = "ProjectDto", description = "") @Valid @RequestBody(required = false) ProjectDto projectDto
    );


    /**
     * POST /catalog/api/v1/projects/{uuid}/updateActions : updateActions
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateActions",
        summary = "updateActions",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/projects/{uuid}/updateActions"
    )
    ResponseEntity<Void> updateActions(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * PUT /catalog/api/v1/projects/update/users : updateProjectUsers
     *
     * @param type type (required)
     * @param projectDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateProjectUsers",
        summary = "updateProjectUsers",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/projects/update/users",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ProjectDto> updateProjectUsers(
        @NotNull @Parameter(name = "type", description = "type", required = true) @Valid @RequestParam(value = "type", required = true) String type,
        @Parameter(name = "ProjectDto", description = "") @Valid @RequestBody(required = false) ProjectDto projectDto
    );

}
