package org.qubership.atp.environments.service.rest.server.dto.generated;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemTypeDtoGenerated;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * HistoryItemDtoGenerated
 */

@JsonTypeName("HistoryItem")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-05T07:24:43.791338011Z[Etc/UTC]")
public class HistoryItemDtoGenerated {

  @JsonProperty("type")
  private HistoryItemTypeDtoGenerated type;

  @JsonProperty("version")
  private Integer version;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("modifiedBy")
  private String modifiedBy;

  @JsonProperty("added")
  @Valid
  private List<String> added = null;

  @JsonProperty("deleted")
  @Valid
  private List<String> deleted = null;

  @JsonProperty("changed")
  @Valid
  private List<String> changed = null;

  public HistoryItemDtoGenerated type(HistoryItemTypeDtoGenerated type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public HistoryItemTypeDtoGenerated getType() {
    return type;
  }

  public void setType(HistoryItemTypeDtoGenerated type) {
    this.type = type;
  }

  public HistoryItemDtoGenerated version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * commit nubmer of current changes
   * minimum: 1
   * @return version
  */
  @Min(1) 
  @Schema(name = "version", description = "commit nubmer of current changes", required = false)
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public HistoryItemDtoGenerated modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", example = "2020-04-15T12:34:56.789Z", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public HistoryItemDtoGenerated modifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  
  @Schema(name = "modifiedBy", example = "Administrator", required = false)
  public String getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public HistoryItemDtoGenerated added(List<String> added) {
    this.added = added;
    return this;
  }

  public HistoryItemDtoGenerated addAddedItem(String addedItem) {
    if (this.added == null) {
      this.added = new ArrayList<>();
    }
    this.added.add(addedItem);
    return this;
  }

  /**
   * Get added
   * @return added
  */
  
  @Schema(name = "added", required = false)
  public List<String> getAdded() {
    return added;
  }

  public void setAdded(List<String> added) {
    this.added = added;
  }

  public HistoryItemDtoGenerated deleted(List<String> deleted) {
    this.deleted = deleted;
    return this;
  }

  public HistoryItemDtoGenerated addDeletedItem(String deletedItem) {
    if (this.deleted == null) {
      this.deleted = new ArrayList<>();
    }
    this.deleted.add(deletedItem);
    return this;
  }

  /**
   * Get deleted
   * @return deleted
  */
  
  @Schema(name = "deleted", required = false)
  public List<String> getDeleted() {
    return deleted;
  }

  public void setDeleted(List<String> deleted) {
    this.deleted = deleted;
  }

  public HistoryItemDtoGenerated changed(List<String> changed) {
    this.changed = changed;
    return this;
  }

  public HistoryItemDtoGenerated addChangedItem(String changedItem) {
    if (this.changed == null) {
      this.changed = new ArrayList<>();
    }
    this.changed.add(changedItem);
    return this;
  }

  /**
   * Get changed
   * @return changed
  */
  
  @Schema(name = "changed", required = false)
  public List<String> getChanged() {
    return changed;
  }

  public void setChanged(List<String> changed) {
    this.changed = changed;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryItemDtoGenerated historyItem = (HistoryItemDtoGenerated) o;
    return Objects.equals(this.type, historyItem.type) &&
        Objects.equals(this.version, historyItem.version) &&
        Objects.equals(this.modifiedWhen, historyItem.modifiedWhen) &&
        Objects.equals(this.modifiedBy, historyItem.modifiedBy) &&
        Objects.equals(this.added, historyItem.added) &&
        Objects.equals(this.deleted, historyItem.deleted) &&
        Objects.equals(this.changed, historyItem.changed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, version, modifiedWhen, modifiedBy, added, deleted, changed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryItemDtoGenerated {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    added: ").append(toIndentedString(added)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    changed: ").append(toIndentedString(changed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

